/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.security;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.bind.DatatypeConverter;
import org.azyva.dragom.util.SortedProperties;
import org.azyva.dragom.util.WormFile;

public class CredentialStore {
    private static final String HARDCODED_PASSWORD = "S4ag$*v6G1kMGWvK";
    public static final String PROPERTY_SUFFIX_DEFAULT_USER = ".DefaultUser";
    public static final String PROPERTY_SUFFIX_PASSWORD = ".Password";
    private static final Pattern patternCleanRealm = Pattern.compile("[^A-Za-z0-9_\\-]");
    private SecretKey secretKeyPasswordEncryption;
    private Path pathCredentialFile;
    private Path pathMasterKeyFile;
    private List<ResourcePatternRealmUser> listResourcePatternRealmUser;
    private WormFile.WormFileCache wormFileCacheCredentials;
    private Properties propertiesCredentials;

    public CredentialStore(Path pathCredentialFile, Path pathMasterKeyFile, List<ResourcePatternRealmUser> listResourcePatternRealmUser) {
        this.pathMasterKeyFile = pathMasterKeyFile;
        this.pathCredentialFile = pathCredentialFile;
        this.listResourcePatternRealmUser = listResourcePatternRealmUser;
        byte[] arrayByteMasterKey = new byte[16];
        if (!this.pathMasterKeyFile.toFile().isFile()) {
            SecureRandom secureRandom = new SecureRandom();
            for (int i = 0; i < 16; ++i) {
                arrayByteMasterKey[i] = (byte)(33 + secureRandom.nextInt(94));
            }
            try {
                this.pathMasterKeyFile.getParent().toFile().mkdirs();
                FileOutputStream outputStreamMasterKeyFile = new FileOutputStream(pathMasterKeyFile.toFile());
                ((OutputStream)outputStreamMasterKeyFile).write(arrayByteMasterKey);
                ((OutputStream)outputStreamMasterKeyFile).close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        try {
            FileInputStream inputStreamMasterKeyFile = new FileInputStream(this.pathMasterKeyFile.toFile());
            ((InputStream)inputStreamMasterKeyFile).read(arrayByteMasterKey);
            ((InputStream)inputStreamMasterKeyFile).close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            this.secretKeyPasswordEncryption = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec((new String(arrayByteMasterKey) + System.getProperty("user.name") + HARDCODED_PASSWORD).toCharArray()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        this.wormFileCacheCredentials = WormFile.getCache(this.pathCredentialFile);
        if (!this.pathCredentialFile.toFile().isFile()) {
            this.readPropertiesCredentials();
            this.savePropertiesCredentials();
        }
    }

    private void readPropertiesCredentials() {
        if (this.wormFileCacheCredentials.isModified()) {
            this.propertiesCredentials = new SortedProperties();
            if (this.wormFileCacheCredentials.isExists()) {
                WormFile.AccessHandle accessHandle = this.wormFileCacheCredentials.reserveAccess(false);
                try {
                    this.propertiesCredentials.load(this.wormFileCacheCredentials.getInputStream());
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    accessHandle.release();
                }
            }
        }
    }

    private void savePropertiesCredentials() {
        WormFile.AccessHandle accessHandle = this.wormFileCacheCredentials.reserveAccess(true);
        try {
            this.propertiesCredentials.store(this.wormFileCacheCredentials.getOutputStream(), null);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            accessHandle.release();
        }
    }

    public void resetCredentialFile() {
        this.propertiesCredentials = null;
    }

    public ResourceInfo getResourceInfo(String resource) {
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.resource = resource;
        for (ResourcePatternRealmUser resourcePatternRealmUser : this.listResourcePatternRealmUser) {
            Matcher matcher = resourcePatternRealmUser.patternResource.matcher(resource);
            if (!matcher.matches()) continue;
            StringBuffer stringBuffer = new StringBuffer();
            matcher.appendReplacement(stringBuffer, resourcePatternRealmUser.realm);
            resourceInfo.realm = stringBuffer.toString();
            if (resourceInfo.realm == null || resourceInfo.realm.length() == 0) {
                throw new RuntimeException("No realm extracted from resource " + resource + '.');
            }
            Matcher matcherCleanRealm = patternCleanRealm.matcher(resourceInfo.realm);
            resourceInfo.realm = matcherCleanRealm.replaceAll("_");
            if (resourcePatternRealmUser.user != null) {
                matcher.reset();
                matcher.matches();
                stringBuffer.setLength(0);
                matcher.appendReplacement(stringBuffer, resourcePatternRealmUser.user);
                resourceInfo.user = stringBuffer.toString();
                if (resourceInfo.user != null && resourceInfo.user.length() == 0) {
                    resourceInfo.user = null;
                }
            }
            return resourceInfo;
        }
        return null;
    }

    public String getPassword(String resource, String user) {
        ResourceInfo resourceInfo = this.getResourceInfo(resource);
        if (resourceInfo == null) {
            return null;
        }
        if (user != null && resourceInfo.user != null && !user.equals(resourceInfo.user)) {
            return null;
        }
        if (user == null) {
            user = resourceInfo.user;
        }
        this.readPropertiesCredentials();
        if (user == null) {
            user = this.propertiesCredentials.getProperty(resourceInfo.realm + PROPERTY_SUFFIX_DEFAULT_USER);
        }
        if (user == null) {
            return null;
        }
        String passwordEncrypted = this.propertiesCredentials.getProperty(resourceInfo.realm + '.' + user + PROPERTY_SUFFIX_PASSWORD);
        if (passwordEncrypted == null) {
            return null;
        }
        return this.decryptPassword(passwordEncrypted);
    }

    public boolean setPassword(String resource, String user, String password) {
        ResourceInfo resourceInfo = this.getResourceInfo(resource);
        if (resourceInfo == null) {
            return false;
        }
        if (user != null && resourceInfo.user != null && !user.equals(resourceInfo.user)) {
            return false;
        }
        if (user == null) {
            user = resourceInfo.user;
        }
        this.readPropertiesCredentials();
        if (user == null) {
            user = this.propertiesCredentials.getProperty(resourceInfo.realm + PROPERTY_SUFFIX_DEFAULT_USER);
        }
        if (user == null) {
            return false;
        }
        String passwordEncrypted = this.encryptPassword(password);
        this.propertiesCredentials.setProperty(resourceInfo.realm + '.' + user + PROPERTY_SUFFIX_PASSWORD, passwordEncrypted);
        this.savePropertiesCredentials();
        return true;
    }

    public boolean deletePassword(String resource, String user) {
        ResourceInfo resourceInfo = this.getResourceInfo(resource);
        if (resourceInfo == null) {
            return false;
        }
        if (user != null && resourceInfo.user != null && !user.equals(resourceInfo.user)) {
            return false;
        }
        if (user == null) {
            user = resourceInfo.user;
        }
        this.readPropertiesCredentials();
        if (user == null) {
            user = this.propertiesCredentials.getProperty(resourceInfo.realm + PROPERTY_SUFFIX_DEFAULT_USER);
        }
        if (user == null) {
            return false;
        }
        this.propertiesCredentials.remove(resourceInfo.realm + '.' + user + PROPERTY_SUFFIX_PASSWORD);
        this.savePropertiesCredentials();
        return true;
    }

    private String decryptPassword(String passwordEncrypted) {
        try {
            Cipher cipherPbe = Cipher.getInstance("PBEWithMD5AndDES");
            byte[] arrayBytePasswordEncryptedAndSalt = DatatypeConverter.parseBase64Binary((String)passwordEncrypted);
            byte[] arrayBytePasswordEncrypted = new byte[arrayBytePasswordEncryptedAndSalt.length - 8];
            System.arraycopy(arrayBytePasswordEncryptedAndSalt, 0, arrayBytePasswordEncrypted, 0, arrayBytePasswordEncrypted.length);
            byte[] arrayByteSalt = new byte[8];
            System.arraycopy(arrayBytePasswordEncryptedAndSalt, arrayBytePasswordEncrypted.length, arrayByteSalt, 0, 8);
            cipherPbe.init(2, (Key)this.secretKeyPasswordEncryption, new PBEParameterSpec(arrayByteSalt, 8));
            return new String(cipherPbe.doFinal(arrayBytePasswordEncrypted), "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private String encryptPassword(String password) {
        try {
            Cipher cipherPbe = Cipher.getInstance("PBEWithMD5AndDES");
            cipherPbe.init(1, this.secretKeyPasswordEncryption);
            SecureRandom secureRandom = new SecureRandom();
            byte[] arrayByteSalt = new byte[8];
            for (int i = 0; i < 8; ++i) {
                arrayByteSalt[i] = (byte)secureRandom.nextInt(256);
            }
            cipherPbe.init(1, (Key)this.secretKeyPasswordEncryption, new PBEParameterSpec(arrayByteSalt, 8));
            byte[] arrayBytePasswordEncrypted = cipherPbe.doFinal(password.getBytes("UTF-8"));
            byte[] arrayBytePasswordEncryptedAndSalt = new byte[arrayBytePasswordEncrypted.length + 8];
            System.arraycopy(arrayBytePasswordEncrypted, 0, arrayBytePasswordEncryptedAndSalt, 0, arrayBytePasswordEncrypted.length);
            System.arraycopy(arrayByteSalt, 0, arrayBytePasswordEncryptedAndSalt, arrayBytePasswordEncrypted.length, 8);
            return DatatypeConverter.printBase64Binary((byte[])arrayBytePasswordEncryptedAndSalt);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ResourcePatternRealmUser> getListResourcePatternRealmUser() {
        return Collections.unmodifiableList(this.listResourcePatternRealmUser);
    }

    public List<RealmUser> getListRealmUser() {
        this.readPropertiesCredentials();
        Enumeration<Object> enumKeys = this.propertiesCredentials.keys();
        ArrayList<RealmUser> listRealmUser = new ArrayList<RealmUser>();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            if (!key.endsWith(PROPERTY_SUFFIX_PASSWORD)) continue;
            RealmUser realmUser = new RealmUser();
            int indexDot = key.lastIndexOf(46, key.length() - PROPERTY_SUFFIX_PASSWORD.length() - 1);
            realmUser.realm = key.substring(0, indexDot);
            realmUser.user = key.substring(indexDot + 1, key.length() - PROPERTY_SUFFIX_PASSWORD.length());
            listRealmUser.add(realmUser);
        }
        return listRealmUser;
    }

    public List<RealmUser> getListRealmUserDefault() {
        this.readPropertiesCredentials();
        Enumeration<Object> enumKeys = this.propertiesCredentials.keys();
        ArrayList<RealmUser> listRealmUser = new ArrayList<RealmUser>();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            if (!key.endsWith(PROPERTY_SUFFIX_DEFAULT_USER)) continue;
            RealmUser realmUser = new RealmUser();
            realmUser.realm = key.substring(0, key.length() - PROPERTY_SUFFIX_DEFAULT_USER.length());
            realmUser.user = this.propertiesCredentials.getProperty(key);
            listRealmUser.add(realmUser);
        }
        return listRealmUser;
    }

    public String getDefaultUser(String resource) {
        ResourceInfo resourceInfo = this.getResourceInfo(resource);
        if (resourceInfo == null) {
            return null;
        }
        if (resourceInfo.user != null) {
            return null;
        }
        this.readPropertiesCredentials();
        return this.propertiesCredentials.getProperty(resourceInfo.realm + PROPERTY_SUFFIX_DEFAULT_USER);
    }

    public boolean setDefaultUser(String resource, String user) {
        ResourceInfo resourceInfo = this.getResourceInfo(resource);
        if (resourceInfo == null) {
            return false;
        }
        if (resourceInfo.user != null) {
            return false;
        }
        this.readPropertiesCredentials();
        this.propertiesCredentials.setProperty(resourceInfo.realm + PROPERTY_SUFFIX_DEFAULT_USER, user);
        this.savePropertiesCredentials();
        return true;
    }

    public boolean deleteDefaultUser(String resource) {
        ResourceInfo resourceInfo = this.getResourceInfo(resource);
        if (resourceInfo == null) {
            return false;
        }
        if (resourceInfo.user != null) {
            return false;
        }
        this.readPropertiesCredentials();
        this.propertiesCredentials.remove(resourceInfo.realm + PROPERTY_SUFFIX_DEFAULT_USER);
        this.savePropertiesCredentials();
        return true;
    }

    public static class RealmUser {
        public String realm;
        public String user;
    }

    public static class ResourceInfo {
        public String resource;
        public String realm;
        public String user;
    }

    public static class ResourcePatternRealmUser {
        public Pattern patternResource;
        public String realm;
        public String user;
    }
}

