/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.cliutil;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.ExecContextFactory;
import org.azyva.dragom.execcontext.WorkspaceExecContextFactory;
import org.azyva.dragom.execcontext.support.ExecContextFactoryHolder;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.RootManager;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.reference.ReferencePathMatcher;
import org.azyva.dragom.reference.ReferencePathMatcherAnd;
import org.azyva.dragom.reference.ReferencePathMatcherByElement;
import org.azyva.dragom.reference.ReferencePathMatcherOr;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CliUtil {
    private static final Logger logger = LoggerFactory.getLogger(CliUtil.class);
    public static final String SYS_PROPERTY_IND_USER_PROPERTIES = "org.azyva.dragom.IndUserProperties";
    public static final String SYS_PROPERTY_DEFAULT_USER_PROPERTIES_FILE = "org.azyva.dragom.DefaultUserProperties";
    public static final String SYS_PROPERTY_USER_PROPERTIES_FILE_COMMAND_LINE_OPTION = "org.azyva.dragom.UserPropertiesCommandLineOption";
    public static final String DEFAULT_USER_PROPERTIES_COMMAND_LINE_OPTION = "user-properties";
    public static final String SYS_PROPERTY_IND_SINGLE_TOOL_PROPERTIES = "org.azyva.dragom.IndSingleToolProperties";
    public static final String SYS_PROPERTY_IND_TOOL_PROPERTIES = "org.azyva.dragom.IndToolProperties";
    public static final String SYS_PROPERTY_WORKSPACE_PATH_COMMAND_LINE_OPTION = "org.azyva.dragom.WorkspacePathCommandLineOption";
    public static final String DEFAULT_WORKSPACE_PATH_COMMAND_LINE_OPTION = "workspace";
    public static final String SYS_PROPERTY_TOOL_PROPERTIES_FILE_COMMAND_LINE_OPTION = "org.azyva.dragom.ToolPropertiesCommandLineOption";
    public static final String DEFAULT_TOOL_PROPERTIES_COMMAND_LINE_OPTION = "tool-properties";
    public static final String SYS_PROPERTY_NO_CONFIRM_COMMAND_LINE_OPTION = "org.azyva.dragom.NoConfirmCommandLineOption";
    public static final String DEFAULT_NO_CONFIRM_COMMAND_LINE_OPTION = "no-confirm";
    public static final String SYS_PROPERTY_NO_CONFIRM_CONTEXT_COMMAND_LINE_OPTION = "org.azyva.dragom.NoConfirmContextCommandLineOption";
    public static final String DEFAULT_NO_CONFIRM_CONTEXT_COMMAND_LINE_OPTION = "no-confirm-context";
    public static final String SYS_PROPERTY_HELP_COMMAND_LINE_OPTION = "org.azyva.dragom.HelpCommandLineOption";
    public static final String DEFAULT_HELP_COMMAND_LINE_OPTION = "help";
    public static final String SYS_PROPERTY_ROOT_MODULE_VERSION_COMMAND_LINE_OPTION = "org.azyva.dragom.RootModuleVersionCommandLineOption";
    public static final String DEFAULT_ROOT_MODULE_VERSION_COMMAND_LINE_OPTION = "root-module-version";
    public static final String SYS_PROPERTY_REFERENCE_PATH_MATCHER_COMMAND_LINE_OPTION = "org.azyva.dragom.ReferencePathMatcherCommandLineOption";
    public static final String DEFAULT_REFERENCE_PATH_MATCHER_COMMAND_LINE_OPTION = "reference-path-matcher";
    public static final String SYS_PROPERTY_JAVA_UTIL_LOGGING_CONFIG_FILE = "org.azyva.dragom.JavaUtilLoggingConfigFile";
    private static final String SYS_PROPERTY_PREFIX_INIT_PROPERTY = "org.azyva.dragom.init-property.";
    public static final String MSG_PATTERN_KEY_USER_ERROR_PREFIX = "USER_ERROR_PREFIX";
    public static final String MSG_PATTERN_KEY_ERROR_PARSING_COMMAND_LINE = "ERROR_PARSING_COMMAND_LINE";
    public static final String MSG_PATTERN_KEY_ERROR_PARSING_COMMAND_LINE_OPTION = "ERROR_PARSING_COMMAND_LINE_OPTION";
    public static final String MSG_PATTERN_KEY_INVALID_ARGUMENT_COUNT = "INVALID_ARGUMENT_COUNT";
    public static final String MSG_PATTERN_KEY_INVALID_COMMAND = "INVALID_COMMAND";
    public static final String MSG_PATTERN_KEY_ROOT_MODULE_VERSION_NOT_ALLOWED_WHEN_SPECIFIED_WORKSPACE = "ROOT_MODULE_VERSION_NOT_ALLOWED_WHEN_SPECIFIED_WORKSPACE";
    public static final String MSG_PATTERN_KEY_ROOT_MODULE_VERSION_REQUIRED_WHEN_NOT_SPECIFIED_WORKSPACE = "ROOT_MODULE_VERSION_REQUIRED_WHEN_NOT_SPECIFIED_WORKSPACE";
    public static final String MSG_PATTERN_KEY_ROOT_MODULE_VERSION_REQUIRED_WORKSPACE = "ROOT_MODULE_VERSION_REQUIRED_WORKSPACE";
    public static final String MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_REQUIRED = "REFERENCE_PATH_MATCHER_REQUIRED";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(CliUtil.class.getName() + "ResourceBundle");
    private static Pattern patternPropertyReference = Pattern.compile("\\$\\{([^\\}]+)\\}");

    public static String getUserPropertiesFileCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_USER_PROPERTIES_FILE_COMMAND_LINE_OPTION, DEFAULT_USER_PROPERTIES_COMMAND_LINE_OPTION);
    }

    public static String getToolPropertiesFileCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_TOOL_PROPERTIES_FILE_COMMAND_LINE_OPTION, DEFAULT_TOOL_PROPERTIES_COMMAND_LINE_OPTION);
    }

    public static String getWorkspacePathCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_WORKSPACE_PATH_COMMAND_LINE_OPTION, DEFAULT_WORKSPACE_PATH_COMMAND_LINE_OPTION);
    }

    public static String getNoConfirmCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_NO_CONFIRM_COMMAND_LINE_OPTION, DEFAULT_NO_CONFIRM_COMMAND_LINE_OPTION);
    }

    public static String getNoConfirmContextCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_NO_CONFIRM_CONTEXT_COMMAND_LINE_OPTION, DEFAULT_NO_CONFIRM_CONTEXT_COMMAND_LINE_OPTION);
    }

    public static String getHelpCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_HELP_COMMAND_LINE_OPTION, DEFAULT_HELP_COMMAND_LINE_OPTION);
    }

    public static String getRootModuleVersionCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_ROOT_MODULE_VERSION_COMMAND_LINE_OPTION, DEFAULT_ROOT_MODULE_VERSION_COMMAND_LINE_OPTION);
    }

    public static String getReferencePathMatcherCommandLineOption() {
        Util.applyDragomSystemProperties();
        return System.getProperty(SYS_PROPERTY_REFERENCE_PATH_MATCHER_COMMAND_LINE_OPTION, DEFAULT_REFERENCE_PATH_MATCHER_COMMAND_LINE_OPTION);
    }

    public static void addStandardOptions(Options options) {
        Option option;
        Util.applyDragomSystemProperties();
        if (Util.isNotNullAndTrue((String)System.getProperty(SYS_PROPERTY_IND_USER_PROPERTIES))) {
            option = new Option(null, null);
            option.setLongOpt(CliUtil.getUserPropertiesFileCommandLineOption());
            option.setArgs(1);
            options.addOption(option);
        }
        if (Util.isNotNullAndTrue((String)System.getProperty(SYS_PROPERTY_IND_SINGLE_TOOL_PROPERTIES))) {
            option = new Option("D", null);
            option.setValueSeparator('=');
            option.setArgs(2);
            options.addOption(option);
        }
        if (Util.isNotNullAndTrue((String)System.getProperty(SYS_PROPERTY_IND_TOOL_PROPERTIES))) {
            option = new Option(null, null);
            option.setLongOpt(CliUtil.getToolPropertiesFileCommandLineOption());
            option.setArgs(1);
            options.addOption(option);
        }
        option = new Option(null, null);
        option.setLongOpt(CliUtil.getWorkspacePathCommandLineOption());
        option.setArgs(1);
        options.addOption(option);
        option = new Option(null, null);
        option.setLongOpt(CliUtil.getNoConfirmCommandLineOption());
        options.addOption(option);
        option = new Option(null, null);
        option.setLongOpt(CliUtil.getNoConfirmContextCommandLineOption());
        option.setArgs(1);
        options.addOption(option);
        option = new Option(null, null);
        option.setLongOpt(CliUtil.getHelpCommandLineOption());
        options.addOption(option);
    }

    public static void addRootModuleVersionOptions(Options options) {
        Util.applyDragomSystemProperties();
        Option option = new Option(null, null);
        option.setLongOpt(CliUtil.getRootModuleVersionCommandLineOption());
        option.setArgs(1);
        options.addOption(option);
        option = new Option(null, null);
        option.setLongOpt(CliUtil.getReferencePathMatcherCommandLineOption());
        option.setArgs(1);
        options.addOption(option);
    }

    public static ExecContext setupExecContext(CommandLine commandLine, boolean indSet) {
        String stringPropertiesFile;
        ExecContextFactory execContextFactory = ExecContextFactoryHolder.getExecContextFactory();
        if (!(execContextFactory instanceof WorkspaceExecContextFactory)) {
            throw new RuntimeException("The ExecContextFactory does not support the workspace directory concept.");
        }
        WorkspaceExecContextFactory workspaceExecContextFactory = (WorkspaceExecContextFactory)execContextFactory;
        Properties propertiesInit = Util.getPropertiesDefaultInit();
        Util.applyDragomSystemProperties();
        if (Util.isNotNullAndTrue((String)System.getProperty(SYS_PROPERTY_IND_USER_PROPERTIES))) {
            stringPropertiesFile = commandLine.getOptionValue(CliUtil.getUserPropertiesFileCommandLineOption());
            if (stringPropertiesFile == null) {
                stringPropertiesFile = System.getProperty(SYS_PROPERTY_DEFAULT_USER_PROPERTIES_FILE);
            }
            if (stringPropertiesFile != null) {
                propertiesInit = CliUtil.loadProperties(stringPropertiesFile, propertiesInit);
            }
        }
        for (String initProperty : System.getProperties().stringPropertyNames()) {
            if (!initProperty.startsWith(SYS_PROPERTY_PREFIX_INIT_PROPERTY)) continue;
            propertiesInit.setProperty(initProperty.substring(SYS_PROPERTY_PREFIX_INIT_PROPERTY.length()), System.getProperty(initProperty));
        }
        String workspaceDir = commandLine.getOptionValue(CliUtil.getWorkspacePathCommandLineOption());
        if (workspaceDir != null) {
            propertiesInit.setProperty(workspaceExecContextFactory.getWorkspaceDirInitProperty(), workspaceDir);
        }
        ExecContext execContext = execContextFactory.getExecContext(propertiesInit);
        if (indSet) {
            Properties propertiesTool = null;
            if (Util.isNotNullAndTrue((String)System.getProperty(SYS_PROPERTY_IND_TOOL_PROPERTIES)) && (stringPropertiesFile = commandLine.getOptionValue(CliUtil.getToolPropertiesFileCommandLineOption())) != null) {
                propertiesTool = CliUtil.loadProperties(stringPropertiesFile, null);
            }
            if (Util.isNotNullAndTrue((String)System.getProperty(SYS_PROPERTY_IND_SINGLE_TOOL_PROPERTIES))) {
                Properties propertiesToolSingle = commandLine.getOptionProperties("D");
                if (propertiesTool != null) {
                    propertiesTool.putAll((Map<?, ?>)propertiesToolSingle);
                } else {
                    propertiesTool = propertiesToolSingle;
                }
            }
            if (propertiesTool == null) {
                propertiesTool = new Properties();
            }
            if (commandLine.hasOption(CliUtil.getNoConfirmCommandLineOption())) {
                propertiesTool.setProperty("IND_NO_CONFIRM", "true");
            } else {
                String[] tabNoConfirmContext = commandLine.getOptionValues(CliUtil.getNoConfirmContextCommandLineOption());
                if (tabNoConfirmContext != null) {
                    for (String context : tabNoConfirmContext) {
                        propertiesTool.setProperty("IND_NO_CONFIRM." + context, "true");
                    }
                }
            }
            ExecContextHolder.setAndStartTool((ExecContext)execContext, (Properties)propertiesTool);
        }
        return execContext;
    }

    private static Properties loadProperties(String stringPropertiesFile, Properties propertiesDefault) {
        Properties properties = propertiesDefault;
        logger.debug("Loading properties from " + stringPropertiesFile);
        stringPropertiesFile = stringPropertiesFile.replace("~", Matcher.quoteReplacement(System.getProperty("user.home")));
        try (FileInputStream inputStreamProperties = new FileInputStream(stringPropertiesFile);){
            properties = propertiesDefault == null ? new Properties() : new Properties(propertiesDefault);
            properties.load(inputStreamProperties);
        }
        catch (FileNotFoundException fnfe) {
            logger.debug("Properties file " + stringPropertiesFile + " not found.");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return properties;
    }

    public static boolean hasHelpOption(CommandLine commandLine) {
        return commandLine.hasOption(CliUtil.getHelpCommandLineOption());
    }

    public static List<ModuleVersion> getListModuleVersionRoot(CommandLine commandLine) {
        ArrayList<ModuleVersion> listModuleVersionRoot;
        String[] arrayStringRootModuleVersion = commandLine != null ? commandLine.getOptionValues(CliUtil.getRootModuleVersionCommandLineOption()) : null;
        if (arrayStringRootModuleVersion != null) {
            if (!RootManager.getListModuleVersion().isEmpty()) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ROOT_MODULE_VERSION_NOT_ALLOWED_WHEN_SPECIFIED_WORKSPACE), CliUtil.getRootModuleVersionCommandLineOption(), CliUtil.getHelpCommandLineOption()));
            }
            listModuleVersionRoot = new ArrayList<ModuleVersion>();
            for (int i = 0; i < arrayStringRootModuleVersion.length; ++i) {
                try {
                    listModuleVersionRoot.add(ModuleVersion.parse((String)arrayStringRootModuleVersion[i]));
                    continue;
                }
                catch (ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern(MSG_PATTERN_KEY_ERROR_PARSING_COMMAND_LINE_OPTION), CliUtil.getRootModuleVersionCommandLineOption(), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
            }
        } else {
            if (RootManager.getListModuleVersion().isEmpty()) {
                if (commandLine == null) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ROOT_MODULE_VERSION_REQUIRED_WHEN_NOT_SPECIFIED_WORKSPACE), CliUtil.getHelpCommandLineOption()));
                }
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ROOT_MODULE_VERSION_REQUIRED_WHEN_NOT_SPECIFIED_WORKSPACE), CliUtil.getRootModuleVersionCommandLineOption(), CliUtil.getHelpCommandLineOption()));
            }
            listModuleVersionRoot = RootManager.getListModuleVersion();
        }
        return listModuleVersionRoot;
    }

    public static ReferencePathMatcher getReferencePathMatcher(CommandLine commandLine) {
        Model model = ExecContextHolder.get().getModel();
        if (commandLine != null) {
            String[] arrayStringReferencePathMatcher = commandLine.getOptionValues(CliUtil.getReferencePathMatcherCommandLineOption());
            if (arrayStringReferencePathMatcher == null) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_REQUIRED), CliUtil.getReferencePathMatcherCommandLineOption(), CliUtil.getHelpCommandLineOption()));
            }
            ReferencePathMatcherOr referencePathMatcherOrCommandLine = new ReferencePathMatcherOr();
            for (int i = 0; i < arrayStringReferencePathMatcher.length; ++i) {
                try {
                    referencePathMatcherOrCommandLine.addReferencePathMatcher((ReferencePathMatcher)ReferencePathMatcherByElement.parse((String)arrayStringReferencePathMatcher[i], (Model)model));
                    continue;
                }
                catch (ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern(MSG_PATTERN_KEY_ERROR_PARSING_COMMAND_LINE_OPTION), CliUtil.getReferencePathMatcherCommandLineOption(), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
            }
            ReferencePathMatcherAnd referencePathMatcherAnd = new ReferencePathMatcherAnd();
            referencePathMatcherAnd.addReferencePathMatcher((ReferencePathMatcher)RootManager.getReferencePathMatcherOr());
            referencePathMatcherAnd.addReferencePathMatcher((ReferencePathMatcher)referencePathMatcherOrCommandLine);
            return referencePathMatcherAnd;
        }
        return RootManager.getReferencePathMatcherOr();
    }

    public static String getLocalizedMsgPattern(String msgPatternKey) {
        return resourceBundle.getString(msgPatternKey);
    }

    public static InputStream getLocalizedResourceAsStream(Class<?> clazz, String resourceBaseName) {
        String resourceBaseNameSuffix;
        String resourceBaseNamePrefix;
        int indexDot = resourceBaseName.lastIndexOf(46);
        if (indexDot != -1) {
            resourceBaseNamePrefix = resourceBaseName.substring(0, indexDot);
            resourceBaseNameSuffix = resourceBaseName.substring(indexDot);
        } else {
            resourceBaseNamePrefix = resourceBaseName;
            resourceBaseNameSuffix = "";
        }
        Locale locale = Locale.getDefault();
        String[] arrayCandidate = new String[]{resourceBaseNamePrefix + "_" + locale.getLanguage() + "_" + locale.getScript() + "_" + locale.getCountry() + "_" + locale.getVariant(), resourceBaseNamePrefix + "_" + locale.getLanguage() + "_" + locale.getScript() + "_" + locale.getCountry(), resourceBaseNamePrefix + "_" + locale.getLanguage() + "_" + locale.getScript(), resourceBaseNamePrefix + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant(), resourceBaseNamePrefix + "_" + locale.getLanguage() + "_" + locale.getCountry(), resourceBaseNamePrefix + "_" + locale.getLanguage(), resourceBaseNamePrefix};
        for (String candidate : arrayCandidate) {
            InputStream inputStreamResource;
            if (candidate.endsWith("_") || (inputStreamResource = clazz.getResourceAsStream(candidate + resourceBaseNameSuffix)) == null) continue;
            return inputStreamResource;
        }
        return null;
    }

    public static void initJavaUtilLogging() {
        String javaUtilLoggingConfigFile;
        Util.applyDragomSystemProperties();
        if (System.getProperty("java.util.logging.config.file") == null && (javaUtilLoggingConfigFile = System.getProperty(SYS_PROPERTY_JAVA_UTIL_LOGGING_CONFIG_FILE)) != null) {
            try {
                String javaUtilLoggingConfig = new String(Files.readAllBytes(Paths.get(javaUtilLoggingConfigFile, new String[0])));
                Matcher matcher = patternPropertyReference.matcher(javaUtilLoggingConfig);
                StringBuffer stringBufferNewJavaUtilLoggingConfig = new StringBuffer();
                while (matcher.find()) {
                    String property = matcher.group(1);
                    String value = System.getProperty(property);
                    if (value == null) {
                        throw new RuntimeException("System property " + property + " referenced in " + javaUtilLoggingConfigFile + " is not defined.");
                    }
                    value = value.replace("\\", "\\\\");
                    matcher.appendReplacement(stringBufferNewJavaUtilLoggingConfig, Matcher.quoteReplacement(value));
                }
                matcher.appendTail(stringBufferNewJavaUtilLoggingConfig);
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(stringBufferNewJavaUtilLoggingConfig.toString().getBytes()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

