/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.barfuin.texttree.api.CycleProtection;
import org.barfuin.texttree.api.IdentityScheme;
import org.barfuin.texttree.api.Node;
import org.barfuin.texttree.internal.Callout;

public class CycleDetector {
    private final CycleProtection protectionMode;
    private final IdentityScheme identityScheme;
    private final Set<String> previousNodes = new HashSet<String>();
    private final Deque<String> stack = new ArrayDeque<String>();

    public CycleDetector(@Nonnull CycleProtection pProtectionMode, @Nonnull IdentityScheme pIdentityScheme) {
        this.protectionMode = Objects.requireNonNull(pProtectionMode, "Argument pProtectionMode must not be null");
        this.identityScheme = Objects.requireNonNull(pIdentityScheme, "Argument pIdentityScheme must not be null");
    }

    @Nonnull
    public Callout visit(@Nullable Node pNode) {
        if (this.protectionMode == CycleProtection.Off) {
            return Callout.None;
        }
        Callout result = Callout.None;
        String nodeId = this.getIdForNode(pNode);
        if (this.protectionMode == CycleProtection.PruneRepeating) {
            if (!this.isNullNode(pNode) && this.previousNodes.contains(nodeId)) {
                result = Callout.RepeatingNode;
            } else {
                this.previousNodes.add(nodeId);
            }
        }
        if (this.stack.contains(nodeId)) {
            result = Callout.Cycle;
        } else {
            this.stack.push(nodeId);
        }
        return result;
    }

    @Nonnull
    private String getIdForNode(@Nullable Node pNode) {
        switch (this.identityScheme) {
            case ByKey: {
                return this.isNullNode(pNode) ? "null" : pNode.getKey();
            }
            case ByText: {
                return this.isNullNode(pNode) ? "null" : pNode.getText();
            }
            case ByIdentity: {
                return (this.isNullNode(pNode) ? "null" : pNode.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(pNode));
            }
        }
        throw new IllegalStateException("Bug: Unhandled node identity scheme - " + (Object)((Object)this.identityScheme));
    }

    private boolean isNullNode(@Nullable Node pNode) {
        boolean result = true;
        if (pNode != null) {
            result = this.identityScheme == IdentityScheme.ByKey ? pNode.getKey() == null : (this.identityScheme == IdentityScheme.ByText ? pNode.getText() == null : false);
        }
        return result;
    }

    public void pop() {
        if (this.protectionMode != CycleProtection.Off) {
            this.stack.pop();
        }
    }
}

