/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.internal;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.barfuin.texttree.api.Node;
import org.barfuin.texttree.api.TextTree;
import org.barfuin.texttree.api.TreeOptions;
import org.barfuin.texttree.api.style.AnnotationPosition;
import org.barfuin.texttree.api.style.TreeStyle;
import org.barfuin.texttree.internal.Callout;
import org.barfuin.texttree.internal.ColorizableAppender;
import org.barfuin.texttree.internal.CycleDetector;
import org.barfuin.texttree.internal.TreeElementType;

@NotThreadSafe
public class TextTreeImpl
implements TextTree {
    private final TreeOptions options;
    private ColorizableAppender appender = null;
    private CycleDetector cycleDetector = null;

    public TextTreeImpl() {
        this(null);
    }

    public TextTreeImpl(@Nullable TreeOptions pOptions) {
        this.options = pOptions != null ? pOptions : new TreeOptions();
    }

    @Override
    @Nonnull
    public String render(@Nullable Node pNode) {
        this.init();
        if (pNode != null) {
            this.render("", 0, pNode);
        } else {
            this.appender.appendText(null, null);
        }
        return this.appender.finishUp();
    }

    private void init() {
        this.appender = new ColorizableAppender(this.options);
        this.cycleDetector = new CycleDetector(this.options.getCycleProtection(), this.options.getIdentityScheme());
    }

    private void render(@Nonnull String pPrefix, int pLevel, @Nullable Node pNode) {
        TreeStyle style = this.options.getStyle();
        this.printNodeText(pPrefix, pNode);
        Callout callout = this.cycleDetector.visit(pNode);
        if (callout != Callout.None) {
            this.printCallout(callout);
            return;
        }
        if (this.options.getAnnotationPosition() == AnnotationPosition.NextLine || pNode == null || pNode.getAnnotation() == null) {
            this.appender.newLine();
        }
        if (pNode != null) {
            this.printAnnotation(pPrefix, pNode.getAnnotation());
            if (TextTreeImpl.hasChildren(pNode)) {
                Iterator<? extends Node> iter = pNode.getChildren().iterator();
                while (iter.hasNext()) {
                    boolean maxDepthExceeded = this.options.getMaxDepth() > 0 && pLevel >= this.options.getMaxDepth();
                    Node child = iter.next();
                    this.appender.append(TreeElementType.Edge, pPrefix);
                    this.appender.append(TreeElementType.Edge, iter.hasNext() && !maxDepthExceeded ? style.getJunction() : style.getLastJunction());
                    this.appender.append(TreeElementType.Edge, this.options.getPaddingStr());
                    if (maxDepthExceeded) {
                        this.printCallout(Callout.MaxDepth);
                        break;
                    }
                    this.render(pPrefix + (iter.hasNext() ? style.getIndent() : style.getBlankIndent()) + this.options.getPaddingStr(), pLevel + 1, child);
                }
            }
        }
        this.cycleDetector.pop();
    }

    private void printNodeText(@Nonnull String pPrefix, @Nullable Node pNode) {
        String text;
        String string = text = pNode != null ? pNode.getText() : null;
        if (text != null) {
            String[] lines = text.split(System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i > 0) {
                    this.appender.append(TreeElementType.Edge, pPrefix);
                }
                this.appender.appendText(line, pNode.getColor());
                if (i >= lines.length - 1) continue;
                this.appender.newLine();
            }
        } else {
            this.appender.appendText(null, pNode != null ? pNode.getColor() : null);
        }
    }

    private void printCallout(@Nonnull Callout pCallout) {
        TreeStyle style = this.options.getStyle();
        if (pCallout.isPrintOnSameLine()) {
            this.appender.appendText(" ", null);
        }
        this.appender.append(pCallout.getElementType(), style.getCalloutStart());
        this.appender.append(pCallout.getElementType(), pCallout.getText());
        this.appender.append(pCallout.getElementType(), style.getCalloutEnd());
        this.appender.newLine();
    }

    private void printAnnotation(@Nonnull String pPrefix, @Nullable String pAnnotation) {
        if (pAnnotation != null) {
            TreeStyle style = this.options.getStyle();
            String[] lines = pAnnotation.trim().split(System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (this.options.getAnnotationPosition() == AnnotationPosition.NextLine || i > 0) {
                    this.appender.append(TreeElementType.Edge, pPrefix);
                }
                if (this.options.getAnnotationPosition() == AnnotationPosition.Inline) {
                    if (i > 0) {
                        this.appender.append(TreeElementType.Annotation, "  ");
                    } else {
                        this.appender.append(TreeElementType.Text, " ");
                    }
                }
                this.appender.append(TreeElementType.Annotation, line);
                this.appender.newLine();
            }
        }
    }

    static boolean hasChildren(@Nullable Node pNode) {
        boolean result = false;
        if (pNode != null && pNode.getChildren() != null) {
            Iterator<? extends Node> iter = pNode.getChildren().iterator();
            return iter != null && iter.hasNext();
        }
        return result;
    }
}

