/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.internal;

import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.barfuin.texttree.api.Node;
import org.barfuin.texttree.api.TextTree;
import org.barfuin.texttree.api.TreeOptions;
import org.barfuin.texttree.api.style.AnnotationPosition;
import org.barfuin.texttree.api.style.TreeStyle;
import org.barfuin.texttree.internal.Callout;
import org.barfuin.texttree.internal.ColorizableAppender;
import org.barfuin.texttree.internal.CycleDetector;
import org.barfuin.texttree.internal.TreeElementType;

@NotThreadSafe
public class TextTreeImpl
implements TextTree {
    private static final String SPACES = "                                                                                                                                                                                   ";
    private final TreeOptions options;
    private ColorizableAppender appender = null;
    private CycleDetector cycleDetector = null;
    private int treeWidth = -1;

    public TextTreeImpl() {
        this(null);
    }

    public TextTreeImpl(@Nullable TreeOptions pOptions) {
        this.options = pOptions != null ? pOptions : new TreeOptions();
    }

    @Override
    @Nonnull
    public String render(@Nullable Node pNode) {
        this.init(pNode);
        if (pNode != null) {
            this.render("", 0, pNode);
        } else {
            this.appender.appendText(null, null);
        }
        return this.appender.finishUp();
    }

    private void init(@Nullable Node pNode) {
        this.appender = new ColorizableAppender(this.options);
        this.cycleDetector = new CycleDetector(this.options.getCycleProtection(), this.options.getIdentityScheme());
        if (this.options.getAnnotationPosition() == AnnotationPosition.Aligned) {
            this.treeWidth = this.precalcTreeWidth(pNode);
        }
    }

    private void render(@Nonnull String pPrefix, int pLevel, @Nullable Node pNode) {
        TreeStyle style = this.options.getStyle();
        this.printNodeText(pPrefix, pNode);
        Callout callout = this.cycleDetector.visit(pNode);
        if (callout != Callout.None) {
            this.printCallout(callout);
            return;
        }
        if (this.options.getAnnotationPosition() == AnnotationPosition.NextLine || this.options.getAnnotationPosition() == AnnotationPosition.None || pNode == null || pNode.getAnnotation() == null) {
            this.appender.newLine();
        }
        if (pNode != null) {
            this.printAnnotation(pPrefix, pNode);
            if (TextTreeImpl.hasChildren(pNode)) {
                Iterator<? extends Node> iter = pNode.getChildren().iterator();
                while (iter.hasNext()) {
                    boolean maxDepthExceeded = this.options.getMaxDepth() > 0 && pLevel >= this.options.getMaxDepth();
                    Node child = iter.next();
                    this.appender.append(TreeElementType.Edge, pPrefix);
                    this.appender.append(TreeElementType.Edge, iter.hasNext() && !maxDepthExceeded ? style.getJunction() : style.getLastJunction());
                    this.appender.append(TreeElementType.Edge, this.options.getPaddingStr());
                    if (maxDepthExceeded) {
                        this.printCallout(Callout.MaxDepth);
                        break;
                    }
                    this.render(pPrefix + (iter.hasNext() ? style.getIndent() : style.getBlankIndent()) + this.options.getPaddingStr(), pLevel + 1, child);
                }
            }
        }
        this.cycleDetector.pop();
    }

    private void printNodeText(@Nonnull String pPrefix, @Nullable Node pNode) {
        String text;
        String string = text = pNode != null ? pNode.getText() : null;
        if (text != null) {
            String[] lines = text.split(System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i > 0) {
                    this.appender.append(TreeElementType.Edge, pPrefix);
                }
                this.appender.appendText(line, pNode.getColor());
                if (i >= lines.length - 1) continue;
                this.appender.newLine();
            }
        } else {
            this.appender.appendText(null, pNode != null ? pNode.getColor() : null);
        }
    }

    private void printCallout(@Nonnull Callout pCallout) {
        TreeStyle style = this.options.getStyle();
        if (pCallout.isPrintOnSameLine()) {
            this.appender.appendText(" ", null);
        }
        this.appender.append(pCallout.getElementType(), style.getCalloutStart());
        this.appender.append(pCallout.getElementType(), pCallout.getText());
        this.appender.append(pCallout.getElementType(), style.getCalloutEnd());
        this.appender.newLine();
    }

    private void printAnnotation(@Nonnull String pPrefix, @Nonnull Node pNode) {
        String annotation = pNode.getAnnotation();
        if (annotation != null && !annotation.isEmpty() && this.options.getAnnotationPosition() != AnnotationPosition.None) {
            String[] lines = annotation.trim().split(System.lineSeparator());
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (this.options.getAnnotationPosition() == AnnotationPosition.NextLine || i > 0) {
                    this.appender.append(TreeElementType.Edge, pPrefix);
                }
                if (this.options.getAnnotationPosition() == AnnotationPosition.Inline) {
                    if (i > 0) {
                        this.appender.append(TreeElementType.Annotation, "  ");
                    } else {
                        this.appender.append(TreeElementType.Text, " ");
                    }
                } else if (this.options.getAnnotationPosition() == AnnotationPosition.Aligned) {
                    int numSpaces = Math.max(1, this.treeWidth - this.appender.getCurrentLineLength() + 1);
                    if (i > 0 && TextTreeImpl.hasChildren(pNode)) {
                        this.appender.append(TreeElementType.Edge, this.options.getStyle().getIndent());
                        numSpaces -= this.options.getStyle().getIndent().length();
                    }
                    this.appender.append(TreeElementType.Annotation, this.nSpaces(numSpaces));
                }
                this.appender.append(TreeElementType.Annotation, line);
                this.appender.newLine();
            }
        }
    }

    static boolean hasChildren(@Nullable Node pNode) {
        boolean result = false;
        if (pNode != null && pNode.getChildren() != null) {
            Iterator<? extends Node> iter = pNode.getChildren().iterator();
            return iter != null && iter.hasNext();
        }
        return result;
    }

    private int precalcTreeWidth(@Nullable Node pNode) {
        TreeOptions noAnnotations = TreeOptions.copyOf(this.options);
        noAnnotations.setAnnotationPosition(AnnotationPosition.None);
        noAnnotations.setColorScheme(null);
        TextTreeImpl textTree = new TextTreeImpl(noAnnotations);
        String bareTree = textTree.render(pNode);
        return this.longestLine(bareTree);
    }

    int longestLine(@Nonnull String pMultilineString) {
        int result = -1;
        int startOfLine = 0;
        int nlPos = pMultilineString.indexOf(System.lineSeparator());
        while (nlPos >= 0) {
            int lineLength = nlPos - startOfLine;
            if (lineLength > result) {
                result = lineLength;
            }
            startOfLine = nlPos + System.lineSeparator().length();
            nlPos = pMultilineString.indexOf(System.lineSeparator(), startOfLine);
        }
        int lineLength = pMultilineString.length() - startOfLine;
        if (lineLength > result) {
            result = lineLength;
        }
        return result;
    }

    String nSpaces(int pNumSpaces) {
        if (pNumSpaces <= SPACES.length()) {
            return SPACES.substring(0, pNumSpaces);
        }
        return Stream.generate(() -> " ").limit(pNumSpaces).collect(Collectors.joining());
    }
}

