/*
 * Copyright 2020 the text-tree contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.barfuin.texttree.internal;

import java.util.regex.Pattern;
import javax.annotation.Nullable;


/**
 * Utility class with static helper methods for internal use by text-tree classes.
 */
public final class TreeUtil
{
    private static final Pattern RTRIM = Pattern.compile("\\s+$");



    private TreeUtil()
    {
        // utility class
    }



    /**
     * Remove all whitespace from the right side of a String.
     *
     * @param pString any String
     * @return a new, trimmed String, or <code>null</code> if the input was <code>null</code>
     */
    public static String rtrim(@Nullable final String pString)
    {
        String result = null;
        if (pString != null) {
            result = RTRIM.matcher(pString).replaceAll("");
        }
        return result;
    }
}
