/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.basinmc.lavatory.ResolverContextImpl;
import org.basinmc.lavatory.rule.feature.Feature;
import org.basinmc.lavatory.rule.system.OperatingSystem;

public interface ResolverContext {
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public OperatingSystem getOperatingSystem();

    @NonNull
    public String getOperatingSystemVersion();

    public boolean isFeatureEnabled(@NonNull Feature var1);

    public static final class Builder {
        private OperatingSystem operatingSystem = OperatingSystem.current();
        private String operatingSystemVersion = System.getProperty("os.version", "0.0");
        private final Set<Feature> features = EnumSet.noneOf(Feature.class);

        private Builder() {
        }

        @NonNull
        public ResolverContext build() {
            return new ResolverContextImpl(this.operatingSystem, this.operatingSystemVersion, this.features);
        }

        @NonNull
        public Builder enableFeature(Feature ... features) {
            this.features.addAll(Arrays.asList(features));
            return this;
        }

        @NonNull
        public Builder disableFeature(Feature ... features) {
            this.features.removeAll(Arrays.asList(features));
            return this;
        }

        @NonNull
        public Builder withDetectedOperatingSystem() {
            return this.withOperatingSystem(OperatingSystem.current());
        }

        @NonNull
        public Builder withDetectedOperatingSystemVersion() {
            return this.withOperatingSystemVersion(System.getProperty("os.version", "0.0"));
        }

        @NonNull
        public Builder withOperatingSystem(@NonNull OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @NonNull
        public Builder withOperatingSystemVersion(@NonNull String version) {
            this.operatingSystemVersion = version;
            return this;
        }
    }
}

