/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.asset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.basinmc.lavatory.asset.AssetIndex;
import org.basinmc.lavatory.file.Download;

public class AssetIndexReference
extends Download {
    private final String id;
    private final long totalSize;

    @JsonCreator
    public AssetIndexReference(@JsonProperty(value="id", required=true) @NonNull String id, @JsonProperty(value="sha1", required=true) @NonNull String sha1, @JsonProperty(value="size", required=true) long size, @JsonProperty(value="url", required=true) @NonNull URL url, @JsonProperty(value="totalSize", required=true) long totalSize) {
        super(sha1, size, url);
        this.id = id;
        this.totalSize = totalSize;
    }

    @NonNull
    public AssetIndex fetch() throws IOException {
        try (InputStream inputStream = this.getUrl().openStream();){
            AssetIndex assetIndex = AssetIndex.read(inputStream);
            return assetIndex;
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AssetIndexReference that = (AssetIndexReference)o;
        return this.totalSize == that.totalSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.totalSize);
    }
}

