/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.basinmc.lavatory.file.LibraryArtifact;
import org.basinmc.lavatory.rule.AbstractRuleControlledResource;
import org.basinmc.lavatory.rule.Rule;

public class LibraryReference
extends AbstractRuleControlledResource
implements Comparable<LibraryReference> {
    private final String name;
    private final LibraryArtifact linuxNativesArtifact;
    private final LibraryArtifact macNativesArtifact;
    private final LibraryArtifact windowsNativesArtifact;
    private final DownloadMap downloads;
    private final ExtractionConfiguration extractionConfiguration;

    public LibraryReference(@NonNull String name, @Nullable LibraryArtifact linuxNativesArtifact, @Nullable LibraryArtifact macNativesArtifact, @Nullable LibraryArtifact windowsNativesArtifact, @NonNull DownloadMap downloads, @Nullable ExtractionConfiguration extractionConfiguration, @Nullable Set<Rule> rules) {
        super(rules);
        this.name = name;
        this.linuxNativesArtifact = linuxNativesArtifact;
        this.macNativesArtifact = macNativesArtifact;
        this.windowsNativesArtifact = windowsNativesArtifact;
        this.downloads = downloads;
        this.extractionConfiguration = extractionConfiguration;
    }

    @JsonCreator
    protected LibraryReference(@JsonProperty(value="name", required=true) @NonNull String name, @JsonProperty(value="downloads", required=true) @NonNull DownloadMap downloads, @JsonProperty(value="natives") @Nullable Map<String, String> classifierMap, @JsonProperty(value="extract") @Nullable ExtractionConfiguration extractionConfiguration, @JsonProperty(value="rules") @Nullable Set<Rule> rules) {
        super(rules);
        String classifier;
        this.name = name;
        this.downloads = downloads;
        this.extractionConfiguration = extractionConfiguration;
        if (classifierMap == null) {
            classifierMap = Collections.emptyMap();
        }
        this.linuxNativesArtifact = (classifier = classifierMap.get("linux")) != null ? (LibraryArtifact)this.downloads.classifiers.get(classifier) : null;
        classifier = classifierMap.get("osx");
        this.macNativesArtifact = classifier != null ? (LibraryArtifact)this.downloads.classifiers.get(classifier) : null;
        classifier = classifierMap.get("windows");
        this.windowsNativesArtifact = classifier != null ? (LibraryArtifact)this.downloads.classifiers.get(classifier) : null;
    }

    public int calculatePriority() {
        return this.downloads.classifiers.size() + (this.downloads.artifact != null ? 1 : 0) + (this.linuxNativesArtifact != null ? 1 : 0) + (this.macNativesArtifact != null ? 1 : 0) + (this.windowsNativesArtifact != null ? 1 : 0) + (this.extractionConfiguration != null ? 1 : 0);
    }

    @Override
    public int compareTo(@NonNull LibraryReference libraryReference) {
        return Math.min(1, Math.max(-1, this.calculatePriority() - libraryReference.calculatePriority()));
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Optional<LibraryArtifact> getLinuxNativesArtifact() {
        return Optional.ofNullable(this.linuxNativesArtifact);
    }

    @NonNull
    public Optional<LibraryArtifact> getMacNativesArtifact() {
        return Optional.ofNullable(this.macNativesArtifact);
    }

    @NonNull
    public Optional<LibraryArtifact> getWindowsNativesArtifact() {
        return Optional.ofNullable(this.windowsNativesArtifact);
    }

    @NonNull
    public DownloadMap getDownloads() {
        return this.downloads;
    }

    @NonNull
    public Optional<ExtractionConfiguration> getExtractionConfiguration() {
        return Optional.ofNullable(this.extractionConfiguration);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryReference that = (LibraryReference)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.linuxNativesArtifact, that.linuxNativesArtifact) && Objects.equals(this.macNativesArtifact, that.macNativesArtifact) && Objects.equals(this.windowsNativesArtifact, that.windowsNativesArtifact) && Objects.equals(this.downloads, that.downloads) && Objects.equals(this.extractionConfiguration, that.extractionConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.linuxNativesArtifact, this.macNativesArtifact, this.windowsNativesArtifact, this.downloads, this.extractionConfiguration);
    }

    public static class ExtractionConfiguration {
        private final Set<String> excludes;
        private final Set<String> includes;

        @JsonCreator
        public ExtractionConfiguration(@JsonProperty(value="exclude") @Nullable Set<String> excludes, @JsonProperty(value="include") @Nullable Set<String> includes) {
            this.excludes = excludes == null ? Collections.emptySet() : excludes;
            this.includes = includes == null ? Collections.emptySet() : includes;
        }

        @NonNull
        public Set<String> getExcludes() {
            return Collections.unmodifiableSet(this.excludes);
        }

        @NonNull
        public Set<String> getIncludes() {
            return Collections.unmodifiableSet(this.includes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtractionConfiguration that = (ExtractionConfiguration)o;
            return Objects.equals(this.excludes, that.excludes) && Objects.equals(this.includes, that.includes);
        }

        public int hashCode() {
            return Objects.hash(this.excludes, this.includes);
        }
    }

    public static class DownloadMap {
        private final LibraryArtifact artifact;
        private final Map<String, LibraryArtifact> classifiers;

        @JsonCreator
        public DownloadMap(@JsonProperty(value="artifact") @Nullable LibraryArtifact artifact, @JsonProperty(value="classifiers") @Nullable Map<String, LibraryArtifact> classifiers) {
            this.artifact = artifact;
            this.classifiers = classifiers == null ? Collections.emptyMap() : classifiers;
        }

        @NonNull
        public Optional<LibraryArtifact> getArtifact() {
            return Optional.ofNullable(this.artifact);
        }

        @NonNull
        public Map<String, LibraryArtifact> getClassifiers() {
            return Collections.unmodifiableMap(this.classifiers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DownloadMap that = (DownloadMap)o;
            return Objects.equals(this.artifact, that.artifact) && Objects.equals(this.classifiers, that.classifiers);
        }

        public int hashCode() {
            return Objects.hash(this.artifact, this.classifiers);
        }
    }
}

