/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.rule;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.basinmc.lavatory.ResolverContext;
import org.basinmc.lavatory.rule.RuleCondition;
import org.basinmc.lavatory.rule.feature.FeatureCondition;
import org.basinmc.lavatory.rule.system.OperatingSystemCondition;

@JsonDeserialize(using=Deserializer.class)
public class Rule {
    private final Action action;
    private final Set<RuleCondition> conditions;

    public Rule(@NonNull Action action, @NonNull Set<RuleCondition> conditions) {
        this.action = action;
        this.conditions = new HashSet<RuleCondition>(conditions);
    }

    public Action evaluate(@NonNull ResolverContext ctx) {
        if (this.conditions.stream().allMatch(c -> c.evaluate(ctx))) {
            return this.action;
        }
        return Action.negate(this.action);
    }

    @NonNull
    public Action getAction() {
        return this.action;
    }

    @NonNull
    public Set<RuleCondition> getConditions() {
        return Collections.unmodifiableSet(this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.action == rule.action && Objects.equals(this.conditions, rule.conditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.conditions});
    }

    public static class Deserializer
    extends JsonDeserializer<Rule> {
        @NonNull
        public Rule deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
            ObjectMapper mapper = (ObjectMapper)p.getCodec();
            ObjectNode node = (ObjectNode)p.readValueAsTree();
            Action action = null;
            if (!node.has("action")) {
                ctxt.reportInputMismatch(Rule.class, "Illegal rule definition: Missing action", new Object[0]);
            }
            try {
                action = Action.valueOf(node.get("action").asText().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                ctxt.reportInputMismatch(Action.class, "Illegal action definition", new Object[0]);
            }
            HashSet<RuleCondition> conditions = new HashSet<RuleCondition>();
            if (node.has("features")) {
                conditions.add((RuleCondition)mapper.treeToValue((TreeNode)node.get("features"), FeatureCondition.class));
            }
            if (node.has("os")) {
                conditions.add((RuleCondition)mapper.treeToValue((TreeNode)node.get("os"), OperatingSystemCondition.class));
            }
            return new Rule(action, conditions);
        }
    }

    public static enum Action {
        ALLOW,
        DISALLOW;


        @NonNull
        public static Action negate(@NonNull Action action) {
            if (action == ALLOW) {
                return DISALLOW;
            }
            return ALLOW;
        }
    }
}

