/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.rule.feature;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.basinmc.lavatory.ResolverContext;
import org.basinmc.lavatory.rule.RuleCondition;
import org.basinmc.lavatory.rule.feature.Feature;

public class FeatureCondition
implements RuleCondition {
    private final Map<Feature, Boolean> featureMap;

    @JsonCreator
    public FeatureCondition(@NonNull Map<String, Boolean> values) {
        this.featureMap = values.entrySet().stream().collect(Collectors.toMap(e -> Feature.byKey((String)e.getKey()).orElseThrow(() -> new IllegalArgumentException("Unknown feature \"" + (String)e.getKey() + "\"")), Map.Entry::getValue));
    }

    @Override
    public boolean evaluate(@NonNull ResolverContext ctx) {
        return this.featureMap.entrySet().stream().allMatch(e -> ctx.isFeatureEnabled((Feature)((Object)((Object)e.getKey()))) == ((Boolean)e.getValue()).booleanValue());
    }

    @NonNull
    public Map<Feature, Boolean> getFeatureMap() {
        return Collections.unmodifiableMap(this.featureMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureCondition that = (FeatureCondition)o;
        return Objects.equals(this.featureMap, that.featureMap);
    }

    public int hashCode() {
        return Objects.hash(this.featureMap);
    }
}

