/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.rule.system;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum OperatingSystem {
    UNKNOWN,
    LINUX("linux"),
    MAC_OS("osx"),
    WINDOWS("windows");

    private static final Map<String, OperatingSystem> keyMap;
    private final String key;

    private OperatingSystem() {
        this(null);
    }

    private OperatingSystem(String key) {
        this.key = key;
    }

    @NonNull
    public static OperatingSystem current() {
        String name = System.getProperty("os.name", "unknown");
        if (name.contains("linux")) {
            return LINUX;
        }
        if (name.contains("osx")) {
            return MAC_OS;
        }
        if (name.contains("win")) {
            return WINDOWS;
        }
        return UNKNOWN;
    }

    @NonNull
    public static Optional<OperatingSystem> byKey(@NonNull String key) {
        return Optional.ofNullable(keyMap.get(key));
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    static {
        keyMap = new HashMap<String, OperatingSystem>();
        for (OperatingSystem os : OperatingSystem.values()) {
            if (os.key == null) continue;
            keyMap.put(os.key, os);
        }
    }
}

