/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.DiscriminatorColumn;
import org.batoo.jpa.jdbc.ForeignKey;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.OrderColumn;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.ColumnTransformerMetadata;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public abstract class AbstractTable {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private String name;
    private final Map<String, AbstractColumn> columnMap = Maps.newHashMap();
    private final Map<String, String[]> uniqueConstraints = Maps.newHashMap();
    private final List<ForeignKey> foreignKeys = Lists.newArrayList();
    private BasicColumn versionColumn;
    private final HashMap<String, String> insertSqlMap = Maps.newHashMap();
    private final HashMap<EntityTypeDescriptor, String> updateSqlMap = Maps.newHashMap();
    private String updateSql;
    private FinalWrapper<String> versionUpdateSql;
    private FinalWrapper<String> versionSelectSql;
    private FinalWrapper<AbstractColumn[]> columns;
    private AbstractColumn[] updateColumns;
    private AbstractColumn[] selectVersionColumns;
    private final Map<String, AbstractColumn[]> insertColumnsMap = Maps.newHashMap();
    private final Map<EntityTypeDescriptor, AbstractColumn[]> updateColumnsMap = Maps.newHashMap();
    private FinalWrapper<String> restrictionSql;
    private AbstractColumn[] restrictionColumns;

    public AbstractTable(String defaultName, TableMetadata metadata) {
        this(metadata);
        if (this.name == null) {
            this.name = defaultName;
        }
    }

    public AbstractTable(TableMetadata metadata) {
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.catalog = metadata != null && StringUtils.isNotBlank((String)metadata.getCatalog()) ? metadata.getCatalog() : null;
        String string = this.schema = metadata != null && StringUtils.isNotBlank((String)metadata.getSchema()) ? metadata.getSchema() : null;
        if (metadata != null) {
            if (StringUtils.isNotBlank((String)metadata.getName())) {
                this.name = metadata.getName();
            }
            for (UniqueConstraintMetadata constraint : metadata.getUniqueConstraints()) {
                this.uniqueConstraints.put(constraint.getName(), constraint.getColumnNames());
            }
        }
    }

    public void addColumn(AbstractColumn column) {
        AbstractColumn existing;
        if (column instanceof BasicColumn && ((BasicColumn)column).isVersion()) {
            if (this.versionColumn != null) {
                throw new MappingException("There can be only one version column", new AbstractLocator[]{this.versionColumn.getLocator(), column.getLocator()});
            }
            this.versionColumn = (BasicColumn)column;
        }
        if ((existing = this.columnMap.get(column.getName())) != null) {
            if (column instanceof JoinColumn) {
                JoinColumn joinColumn = (JoinColumn)column;
                if (!joinColumn.isInsertable() && !joinColumn.isUpdatable()) {
                    joinColumn.setVirtual(existing);
                }
                return;
            }
            if (!column.isInsertable() && !column.isUpdatable()) {
                return;
            }
            throw new MappingException("Duplicate column names " + column.getName() + " on table " + this.name, new AbstractLocator[]{column.getLocator(), existing.getLocator()});
        }
        this.columnMap.put(column.getName(), column);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    private synchronized void generateInsertSql(final EntityTypeDescriptor type, int size) {
        ArrayList insertColumns;
        String sqlKey = type != null ? type.getName() + size : "" + size;
        String sql = this.insertSqlMap.get(sqlKey);
        if (sql != null) {
            return;
        }
        Collection filteredColumns = type == null ? this.columnMap.values() : Collections2.filter(this.columnMap.values(), (Predicate)new Predicate<AbstractColumn>(){

            public boolean apply(AbstractColumn input) {
                return AbstractTable.this.isInsertableColumn(type, input);
            }
        });
        Collection columnNames = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>((List)(insertColumns = Lists.newArrayList())){
            final /* synthetic */ List val$insertColumns;
            {
                this.val$insertColumns = list;
            }

            public String apply(AbstractColumn input) {
                this.val$insertColumns.add(input);
                return input.getName();
            }
        });
        if (columnNames.size() == 0) {
            sql = "INSERT INTO " + this.getQName() + " DEFAULT VALUES";
        } else {
            Collection singleParams = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

                public String apply(AbstractColumn input) {
                    String writeParam = null;
                    if (input instanceof BasicColumn) {
                        ColumnTransformerMetadata columnTransformer = ((BasicColumn)input).getMapping().getColumnTransformer();
                        writeParam = columnTransformer != null ? columnTransformer.getWrite() : null;
                    }
                    writeParam = Strings.isNullOrEmpty(writeParam) ? "?" : writeParam;
                    return writeParam;
                }
            });
            String singleParamStr = "\t(" + Joiner.on((String)", ").join((Iterable)singleParams) + ")";
            String parametersStr = StringUtils.repeat((String)singleParamStr, (String)",\n", (int)size);
            String columnNamesStr = Joiner.on((String)", ").join((Iterable)columnNames);
            sql = "INSERT INTO " + this.getQName() + "\n(" + columnNamesStr + ")" + "\nVALUES\n" + parametersStr;
        }
        this.insertSqlMap.put(sqlKey, sql);
        this.insertColumnsMap.put(sqlKey, insertColumns.toArray(new AbstractColumn[insertColumns.size()]));
    }

    private synchronized void generateUpdateSql(final EntityTypeDescriptor type, Map<String, AbstractColumn> pkColumns) {
        String sql = this.updateSqlMap.get(type);
        if (sql != null) {
            return;
        }
        final ArrayList updateColumns = Lists.newArrayList();
        Collection filteredColumns = type == null ? this.columnMap.values() : Collections2.filter(this.columnMap.values(), (Predicate)new Predicate<AbstractColumn>(){

            public boolean apply(AbstractColumn input) {
                return AbstractTable.this.isUpdatableColumn(type, input);
            }
        });
        Collection columnNames = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                if (!input.isPrimaryKey()) {
                    updateColumns.add(input);
                    return input.getName() + " = ?";
                }
                return null;
            }
        });
        String columnNamesStr = Joiner.on((String)", ").skipNulls().join((Iterable)columnNames);
        sql = "UPDATE " + this.getQName() + " SET" + "\n" + columnNamesStr + "\nWHERE " + this.getRestrictionSql(pkColumns);
        if (type != null) {
            this.updateSqlMap.put(type, sql);
            this.updateColumnsMap.put(type, updateColumns.toArray(new AbstractColumn[updateColumns.size()]));
        } else {
            this.updateSql = sql;
            this.updateColumns = updateColumns.toArray(new AbstractColumn[updateColumns.size()]);
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    protected Map<String, AbstractColumn> getColumnMap() {
        return this.columnMap;
    }

    public Collection<String> getColumnNames() {
        return Collections2.transform(this.columnMap.values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                return input.getName();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractColumn[] getColumns() {
        FinalWrapper<AbstractColumn[]> wrapper = this.columns;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.columns == null) {
                    this.columns = new FinalWrapper((Object)this.columnMap.values().toArray(new AbstractColumn[this.columnMap.values().size()]));
                }
                wrapper = this.columns;
            }
        }
        return (AbstractColumn[])wrapper.value;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    protected AbstractColumn[] getInsertColumns(EntityTypeDescriptor entity, int size) {
        return this.insertColumnsMap.get(entity != null ? entity.getName() + size : "" + size);
    }

    protected String getInsertSql(EntityTypeDescriptor entity, int size) {
        String sqlKey = entity != null ? entity.getName() + size : "" + size;
        String sql = this.insertSqlMap.get(sqlKey);
        if (sql != null) {
            return sql;
        }
        this.generateInsertSql(entity, size);
        return this.insertSqlMap.get(sqlKey);
    }

    public AbstractLocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPkColumnNames() {
        return Collections.emptySet();
    }

    public String getQName() {
        return Joiner.on((String)".").skipNulls().join((Object)this.schema, (Object)this.name, new Object[0]);
    }

    public AbstractColumn[] getRestrictionColumns() {
        return this.restrictionColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRestrictionSql(Map<String, AbstractColumn> pkColumns) {
        FinalWrapper<String> wrapper = this.restrictionSql;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.restrictionSql == null) {
                    ArrayList _restrictionColumns = Lists.newArrayList();
                    _restrictionColumns.addAll(pkColumns.values());
                    String _restrictionSql = Joiner.on((String)" AND ").join((Iterable)Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

                        public String apply(AbstractColumn input) {
                            return input.getName() + " = ?";
                        }
                    }));
                    if (this.versionColumn != null) {
                        _restrictionColumns.add(this.versionColumn);
                        _restrictionSql = _restrictionSql + " AND " + this.versionColumn.getName() + " = ?";
                    }
                    this.restrictionColumns = _restrictionColumns.toArray(new AbstractColumn[_restrictionColumns.size()]);
                    this.restrictionSql = new FinalWrapper((Object)_restrictionSql);
                }
                wrapper = this.restrictionSql;
            }
        }
        return (String)this.restrictionSql.value;
    }

    public String getSchema() {
        return this.schema;
    }

    public AbstractColumn[] getSelectVersionColumns() {
        return this.selectVersionColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectVersionSql(Map<String, AbstractColumn> pkColumns) {
        FinalWrapper<String> wrapper = this.versionSelectSql;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.versionSelectSql == null) {
                    AbstractColumn versionColumn = null;
                    for (AbstractColumn column : this.getColumns()) {
                        if (!(column instanceof BasicColumn) || !((BasicColumn)column).isVersion()) continue;
                        versionColumn = column;
                    }
                    final ArrayList selectVersionColumns = Lists.newArrayList();
                    Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

                        public String apply(AbstractColumn input) {
                            selectVersionColumns.add(input);
                            return input.getName() + " = ?";
                        }
                    });
                    String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
                    if (versionColumn != null) {
                        this.versionSelectSql = new FinalWrapper((Object)("SELECT " + versionColumn.getName() + " FROM " + this.getQName() + "\nWHERE " + restrictionStr));
                        this.selectVersionColumns = selectVersionColumns.toArray(new AbstractColumn[selectVersionColumns.size()]);
                    }
                }
                wrapper = this.versionSelectSql;
            }
        }
        return (String)wrapper.value;
    }

    public Map<String, String[]> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    protected AbstractColumn[] getUpdateColumns(EntityTypeDescriptor entity) {
        if (entity == null) {
            return this.updateColumns;
        }
        return this.updateColumnsMap.get(entity);
    }

    protected String getUpdateSql(EntityTypeDescriptor entity, Map<String, AbstractColumn> pkColumns) {
        if (entity == null) {
            if (this.updateSql == null) {
                this.generateUpdateSql(null, pkColumns);
            }
            return this.updateSql;
        }
        String sql = this.updateSqlMap.get(entity);
        if (sql == null) {
            this.generateUpdateSql(entity, pkColumns);
            sql = this.updateSqlMap.get(entity);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getVersionUpdateSql(Map<String, AbstractColumn> pkColumns) {
        FinalWrapper<String> wrapper = this.versionUpdateSql;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.versionUpdateSql == null) {
                    this.versionUpdateSql = new FinalWrapper((Object)("UPDATE " + this.getQName() + " SET" + "\n" + this.versionColumn.getName() + " = ?" + "\nWHERE " + this.getRestrictionSql(pkColumns)));
                }
                wrapper = this.versionUpdateSql;
            }
        }
        return (String)wrapper.value;
    }

    private boolean isInsertableColumn(EntityTypeDescriptor type, AbstractColumn input) {
        EntityTypeDescriptor root;
        if (input.getIdType() == IdType.IDENTITY) {
            return false;
        }
        if (!input.isInsertable()) {
            return false;
        }
        if (input instanceof DiscriminatorColumn) {
            return true;
        }
        if (input instanceof JoinColumn && input.getMapping() == null) {
            root = (EntityTypeDescriptor)((JoinColumn)input).getReferencedColumn().getMapping().getRoot().getTypeDescriptor();
        } else {
            if (input instanceof OrderColumn) {
                return input.isInsertable();
            }
            root = (EntityTypeDescriptor)input.getMapping().getRoot().getTypeDescriptor();
        }
        Class<?> parent = root.getJavaType();
        Class<?> javaType = type.getJavaType();
        return parent.isAssignableFrom(javaType);
    }

    private boolean isUpdatableColumn(EntityTypeDescriptor type, AbstractColumn input) {
        if (input.isPrimaryKey() || input instanceof DiscriminatorColumn) {
            return false;
        }
        if (!input.isUpdatable()) {
            return false;
        }
        EntityTypeDescriptor root = input instanceof JoinColumn && input.getMapping() == null ? (EntityTypeDescriptor)((JoinColumn)input).getReferencedColumn().getMapping().getRoot().getTypeDescriptor() : (EntityTypeDescriptor)input.getMapping().getRoot().getTypeDescriptor();
        Class<?> parent = root.getJavaType();
        Class<?> javaType = type.getJavaType();
        return parent.isAssignableFrom(javaType);
    }

    protected void setName(String name) {
        this.name = name;
    }
}

