/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;

public class TypeFactory {
    public static int getSqlType(Class<?> javaType, TemporalType temporal, EnumType enumType, boolean isLob) {
        if (isLob) {
            if (Character.class.isAssignableFrom(javaType) || String.class.isAssignableFrom(javaType) || javaType.isArray() && Character.TYPE.isAssignableFrom(javaType.getComponentType())) {
                return 2005;
            }
            return 2004;
        }
        if (javaType.isArray()) {
            if (Character.class.isAssignableFrom(javaType.getComponentType()) || Character.TYPE.isAssignableFrom(javaType.getComponentType())) {
                return 2005;
            }
            return 2004;
        }
        if (Boolean.class.isAssignableFrom(javaType) || Boolean.TYPE.isAssignableFrom(javaType)) {
            return 16;
        }
        if (String.class.isAssignableFrom(javaType)) {
            return 12;
        }
        if (Calendar.class.isAssignableFrom(javaType) || Date.class.isAssignableFrom(javaType)) {
            if (temporal == null) {
                return 93;
            }
            switch (temporal) {
                case DATE: {
                    return 91;
                }
                case TIME: {
                    return 92;
                }
                case TIMESTAMP: {
                    return 93;
                }
            }
        }
        if (Enum.class.isAssignableFrom(javaType)) {
            if (enumType == null || enumType == EnumType.ORDINAL) {
                return 5;
            }
            return 12;
        }
        if (Integer.class.isAssignableFrom(javaType) || Integer.TYPE.isAssignableFrom(javaType)) {
            return 4;
        }
        if (Byte.class.isAssignableFrom(javaType) || Byte.TYPE.isAssignableFrom(javaType)) {
            return -6;
        }
        if (Character.class.isAssignableFrom(javaType) || Character.TYPE.isAssignableFrom(javaType)) {
            return 1;
        }
        if (Short.class.isAssignableFrom(javaType) || Short.TYPE.isAssignableFrom(javaType)) {
            return 5;
        }
        if (Long.class.isAssignableFrom(javaType) || Long.TYPE.isAssignableFrom(javaType)) {
            return -5;
        }
        if (Float.class.isAssignableFrom(javaType) || Float.TYPE.isAssignableFrom(javaType)) {
            return 6;
        }
        if (Double.class.isAssignableFrom(javaType) || Double.TYPE.isAssignableFrom(javaType)) {
            return 8;
        }
        if (java.sql.Date.class.isAssignableFrom(javaType)) {
            return 91;
        }
        if (Time.class.isAssignableFrom(javaType)) {
            return 92;
        }
        if (Timestamp.class.isAssignableFrom(javaType)) {
            return 93;
        }
        if (BigDecimal.class.isAssignableFrom(javaType) || BigInteger.class.isAssignableFrom(javaType)) {
            return 3;
        }
        throw new IllegalArgumentException("Cannot determine sql type: " + javaType);
    }
}

