/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import org.batoo.jpa.jdbc.adapter.DerbyAdaptor;
import org.batoo.jpa.jdbc.adapter.H2Adaptor;
import org.batoo.jpa.jdbc.adapter.HsqlAdaptor;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.adapter.MsSqlAdaptor;
import org.batoo.jpa.jdbc.adapter.MySqlAdaptor;
import org.batoo.jpa.jdbc.adapter.OracleAdaptor;
import org.batoo.jpa.jdbc.adapter.PostgreSqlAdaptor;
import org.batoo.jpa.jdbc.adapter.SawSqlAdaptor;

public abstract class AbstractJdbcAdaptor {
    private static final Map<String, JdbcAdaptor> ADAPTERS = AbstractJdbcAdaptor.prepareAdaptors();

    public static JdbcAdaptor getAdapter(ClassLoader classloader, String databaseProductName) {
        JdbcAdaptor jdbcAdaptor = ADAPTERS.get(databaseProductName);
        if (jdbcAdaptor == null) {
            throw new PersistenceException("Cannot locate JDBC Adaptor for '" + databaseProductName + "'");
        }
        try {
            return (JdbcAdaptor)jdbcAdaptor.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Map<String, JdbcAdaptor> prepareAdaptors() {
        HashMap adaptors = Maps.newHashMap();
        AbstractJdbcAdaptor.putAdaptor(adaptors, new DerbyAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new MySqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new MsSqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new OracleAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new H2Adaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new HsqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new PostgreSqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new SawSqlAdaptor());
        return adaptors;
    }

    private static void putAdaptor(Map<String, JdbcAdaptor> adaptors, JdbcAdaptor adaptor) {
        for (String productName : adaptor.getProductNames()) {
            adaptors.put(productName, adaptor);
        }
    }

    public String applyCast(String argument, Class<?> clazz) {
        String className = this.getCastClassName(clazz);
        return "CAST(" + argument + " AS " + className + ")";
    }

    public abstract String applyConcat(List<String> var1);

    public abstract String applyLikeEscape(String var1);

    public abstract String applyLock(String var1, LockModeType var2);

    public abstract String applyPagination(String var1, int var2, int var3);

    public String applySubStr(String innerFragment, String startFragment, String endFragment) {
        return "SUBSTR(" + Joiner.on((String)", ").skipNulls().join(new Object[]{innerFragment, startFragment, endFragment}) + ")";
    }

    public String applyTrim(CriteriaBuilder.Trimspec trimspec, String trimChar, String argument) {
        StringBuilder builder = new StringBuilder("TRIM(");
        if (trimspec != null) {
            builder.append(trimspec.toString()).append(" ");
        }
        if (trimChar != null) {
            builder.append(trimChar).append(" ");
        }
        if (trimspec != null || trimChar != null) {
            builder.append("FROM ");
        }
        return builder.append(argument).append(")").toString();
    }

    public String castBoolean(String sqlFragment) {
        return sqlFragment;
    }

    protected String getCastClassName(Class<?> clazz) {
        if (clazz == String.class) {
            return "VARCHAR";
        }
        return clazz.getSimpleName();
    }

    protected abstract String[] getProductNames();
}

