/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.sql.DataSource;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;

public class H2Adaptor
extends JdbcAdaptor {
    private static final String[] PRODUCT_NAMES = new String[]{"H2"};

    @Override
    public String applyConcat(List<String> arguments) {
        return Joiner.on((String)" || ").join(arguments);
    }

    @Override
    public String applyLikeEscape(String escapePattern) {
        return " {ESCAPE " + escapePattern + "}";
    }

    @Override
    public String applyLock(String sql, LockModeType lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_READ: {
                return sql + "\nFOR READ ONLY";
            }
            case PESSIMISTIC_WRITE: {
                return sql + "\nFOR UPDATE";
            }
        }
        return sql;
    }

    @Override
    public String applyPagination(String sql, int startPosition, int maxResult) {
        if (startPosition != 0 || maxResult != Integer.MAX_VALUE) {
            sql = sql + "\nLIMIT ?";
            if (startPosition != 0) {
                sql = sql + "OFFSET ?";
            }
        }
        return sql;
    }

    @Override
    public String applyTrim(CriteriaBuilder.Trimspec trimspec, String trimChar, String argument) {
        StringBuilder builder = new StringBuilder("TRIM(");
        if (trimspec != null || trimChar != null) {
            if (trimspec == null) {
                trimspec = CriteriaBuilder.Trimspec.BOTH;
            }
            builder.append(trimspec.toString()).append(" ");
        }
        if (trimChar != null) {
            builder.append(trimChar).append(" ");
        }
        if (trimspec != null || trimChar != null) {
            builder.append("FROM ");
        }
        return builder.append(argument).append(")").toString();
    }

    @Override
    public String createColumnDDL(AbstractColumn column) {
        boolean identity = column.getIdType() == IdType.IDENTITY;
        return column.getName() + " " + this.getColumnType(column, column.getSqlType()) + (!column.isNullable() ? " NOT NULL" : "") + (column.isUnique() ? " UNIQUE" : "") + (identity ? " GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1)" : "");
    }

    @Override
    public void createSequenceIfNecessary(DataSource datasource, SequenceGenerator sequence) {
        String sql = "CREATE SEQUENCE " + sequence.getQName() + " START WITH " + sequence.getInitialValue() + " INCREMENT BY " + sequence.getAllocationSize();
        try {
            new QueryRunner(datasource).update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create sequence " + sequence.getName());
        }
    }

    @Override
    protected String getCastClassName(Class<?> clazz) {
        if (clazz == Byte.class) {
            return "TINYINT";
        }
        if (clazz == Short.class) {
            return "SMALLINT";
        }
        if (clazz == Float.class) {
            return "FLOAT4";
        }
        return super.getCastClassName(clazz);
    }

    @Override
    protected String getColumnType(AbstractColumn cd, int sqlType) {
        switch (sqlType) {
            case 2004: {
                return "VARBINARY(" + cd.getLength() + ")";
            }
            case 2005: {
                return "CLOB(" + cd.getLength() + ")";
            }
            case 12: {
                return "VARCHAR(" + cd.getLength() + ")";
            }
            case 92: {
                return "TIME";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -6: 
            case 4: 
            case 5: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 8: {
                return "DOUBLE" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 3: {
                return "DECIMAL" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + (cd.getScale() > 0 ? "," + cd.getScale() : "") + ")" : "");
            }
        }
        throw new IllegalArgumentException("Unhandled sql type: " + sqlType);
    }

    @Override
    protected String getDatabaseName() {
        return "HSqlDb";
    }

    @Override
    protected String getDropForeignKeySql(String schema, String table, String foreignKey) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object)schema, (Object)table, new Object[0]);
        return "ALTER TABLE " + qualifiedName + " DROP CONSTRAINT " + foreignKey;
    }

    @Override
    public long getNextSequence(DataSource datasource, String sequenceName) throws SQLException {
        return ((Number)new QueryRunner(datasource).query("CALL NEXT VALUE FOR " + sequenceName, new SingleValueHandler())).longValue();
    }

    @Override
    public JdbcAdaptor.PaginationParamsOrder getPaginationParamsOrder() {
        return JdbcAdaptor.PaginationParamsOrder.SQL_MAX_START;
    }

    @Override
    protected String[] getProductNames() {
        return PRODUCT_NAMES;
    }

    @Override
    public String getSelectLastIdentitySql(BasicColumn identityColumn) {
        return "CALL IDENTITY()";
    }

    @Override
    protected boolean isForeignKeyHasDefaultIndex() {
        return true;
    }

    @Override
    public boolean paginationNeedsMaxResultsAlways() {
        return true;
    }

    @Override
    public boolean paginationNeedsStartAlways() {
        return false;
    }

    @Override
    public IdType supports(GenerationType type) {
        if (type == null) {
            return IdType.SEQUENCE;
        }
        switch (type) {
            case IDENTITY: {
                return IdType.IDENTITY;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case TABLE: {
                return IdType.TABLE;
            }
        }
        return IdType.SEQUENCE;
    }

    @Override
    public boolean supportsNamedParams() {
        return false;
    }
}

