/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.sql.DataSource;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;

public class OracleAdaptor
extends JdbcAdaptor {
    private static final String[] PRODUCT_NAMES = new String[]{"Oracle"};

    @Override
    public String applyConcat(List<String> arguments) {
        return Joiner.on((String)" || ").join(arguments);
    }

    @Override
    public String applyLikeEscape(String escapePattern) {
        return " ESCAPE " + escapePattern;
    }

    @Override
    public String applyLock(String sql, LockModeType lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_READ: {
                return sql + "\nFOR READ ONLY";
            }
            case PESSIMISTIC_WRITE: {
                return sql + "\nFOR UPDATE";
            }
        }
        return sql;
    }

    @Override
    public String applyPagination(String sql, int startPosition, int maxResult) {
        sql = BatooUtils.indent((String)sql);
        sql = "SELECT PAGING_RESULT_1.*, rownum ROW_NUM__INTERNAL FROM (\n" + sql + "\n) PAGING_RESULT_1 WHERE rownum <= ?";
        sql = BatooUtils.indent((String)sql);
        sql = "SELECT * FROM (\n" + sql + "\n) WHERE ROW_NUM__INTERNAL > ?";
        return sql;
    }

    @Override
    public String applyTrim(CriteriaBuilder.Trimspec trimspec, String trimChar, String argument) {
        StringBuilder builder = new StringBuilder("TRIM(");
        if (trimspec != null || trimChar != null) {
            if (trimspec == null) {
                trimspec = CriteriaBuilder.Trimspec.BOTH;
            }
            builder.append(trimspec.toString()).append(" ");
        }
        if (trimChar != null) {
            builder.append(trimChar).append(" ");
        }
        if (trimspec != null || trimChar != null) {
            builder.append("FROM ");
        }
        return builder.append(argument).append(")").toString();
    }

    @Override
    public String castBoolean(String sqlFragment) {
        return super.castBoolean(sqlFragment) + " = 1";
    }

    @Override
    public String createColumnDDL(AbstractColumn column) {
        return column.getName() + " " + this.getColumnType(column, column.getSqlType()) + (!column.isNullable() ? " NOT NULL" : "") + (column.isUnique() ? " UNIQUE" : "");
    }

    @Override
    public void createSequenceIfNecessary(DataSource datasource, SequenceGenerator sequence) {
        String sql = "CREATE SEQUENCE " + sequence.getQName() + " START WITH " + sequence.getInitialValue() + " INCREMENT BY " + sequence.getAllocationSize();
        try {
            new QueryRunner(datasource).update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create sequence " + sequence.getName());
        }
    }

    @Override
    protected String getColumnType(AbstractColumn cd, int sqlType) {
        switch (sqlType) {
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "NCLOB";
            }
            case 12: {
                return "VARCHAR(" + cd.getLength() + ")";
            }
            case 91: 
            case 92: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "NUMBER(1)";
            }
            case -6: 
            case 4: 
            case 5: {
                return "INTEGER";
            }
            case -5: {
                return "NUMBER(19,0)";
            }
            case 6: {
                return "FLOAT" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 8: {
                return "DOUBLE PRECISION" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 3: {
                return "NUMBER" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + (cd.getScale() > 0 ? "," + cd.getScale() : "") + ")" : "");
            }
        }
        throw new IllegalArgumentException("Unhandled sql type: " + sqlType);
    }

    @Override
    public String getCurrentTime() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    protected String getDatabaseName() {
        return "Oracle";
    }

    @Override
    protected String getDropForeignKeySql(String schema, String table, String foreignKey) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object)schema, (Object)table, new Object[0]);
        return "ALTER TABLE " + qualifiedName + " DROP CONSTRAINT " + foreignKey;
    }

    @Override
    public int getInsertBatchSize() {
        return 1;
    }

    @Override
    public long getNextSequence(DataSource datasource, String sequenceName) throws SQLException {
        return ((Number)new QueryRunner(datasource).query("SELECT " + sequenceName + ".NEXTVAL FROM DUAL", new SingleValueHandler())).longValue();
    }

    @Override
    public JdbcAdaptor.PaginationParamsOrder getPaginationParamsOrder() {
        return JdbcAdaptor.PaginationParamsOrder.SQL_END_START;
    }

    @Override
    protected String[] getProductNames() {
        return PRODUCT_NAMES;
    }

    @Override
    public String getSelectLastIdentitySql(BasicColumn identityColumn) {
        throw new PersistenceException("Identity is not supported by Oracle");
    }

    @Override
    protected boolean isForeignKeyHasDefaultIndex() {
        return false;
    }

    @Override
    public boolean paginationNeedsMaxResultsAlways() {
        return true;
    }

    @Override
    public boolean paginationNeedsStartAlways() {
        return true;
    }

    @Override
    public IdType supports(GenerationType type) {
        if (type == null) {
            return IdType.SEQUENCE;
        }
        switch (type) {
            case IDENTITY: {
                return IdType.SEQUENCE;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case TABLE: {
                return IdType.TABLE;
            }
        }
        return IdType.SEQUENCE;
    }
}

