/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.generator;

import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;

public abstract class IdQueue
extends LinkedBlockingQueue<Long> {
    private static final long serialVersionUID = 1L;
    private static final BLogger LOG = BLoggerFactory.getLogger(IdQueue.class);
    private final String name;
    private final int allocationSize;
    private final ExecutorService idExecuter;

    public IdQueue(ExecutorService idExecuter, String name, int allocationSize) {
        this.idExecuter = idExecuter;
        this.name = name;
        this.allocationSize = allocationSize;
        this.idExecuter.execute(new TopUpTask());
    }

    protected void doTopUp(Runnable runnable) {
        if (this.idExecuter.isShutdown()) {
            return;
        }
        if (this.size() <= this.allocationSize) {
            LOG.debug("Ids will be fetched for {0} from the database...", new Object[]{this.name});
            try {
                long nextSequence = this.getNextId();
                for (int i = 0; i < this.allocationSize; ++i) {
                    this.put(nextSequence + (long)i);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.idExecuter.isShutdown()) {
                    return;
                }
                LOG.fatal((Throwable)e, "Cannot get next id from the database!");
            }
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected abstract Long getNextId() throws SQLException;

    @Override
    public Long poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.size() < this.allocationSize * 2) {
            this.idExecuter.execute(new TopUpTask());
        }
        return (Long)super.poll(timeout, unit);
    }

    private final class TopUpTask
    implements Runnable {
        private TopUpTask() {
        }

        @Override
        public void run() {
            IdQueue.this.doTopUp(this);
        }
    }
}

