/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.generator;

import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.generator.IdQueue;
import org.batoo.jpa.jdbc.generator.TableGenerator;

public class TableIdQueue
extends IdQueue {
    private static final long serialVersionUID = 1L;
    private final DataSource datasource;
    private final transient TableGenerator generator;
    private final transient JdbcAdaptor jdbcAdaptor;
    private String selectSql;
    private String insertSql;
    private String updateSql;
    private Long nextId;

    public TableIdQueue(JdbcAdaptor jdbcAdaptor, DataSource datasource, ExecutorService idExecuter, TableGenerator generator) {
        super(idExecuter, generator.getName(), generator.getAllocationSize());
        this.jdbcAdaptor = jdbcAdaptor;
        this.datasource = datasource;
        this.generator = generator;
    }

    private String getInsertSql() {
        if (this.insertSql == null) {
            this.insertSql = "INSERT INTO " + this.generator.getTable() + "\nVALUES (?, ?)";
        }
        return this.insertSql;
    }

    @Override
    protected synchronized Long getNextId() throws SQLException {
        QueryRunner runner = new QueryRunner(this.datasource, this.jdbcAdaptor.isPmdBroken());
        Number nextId = (Number)runner.query(this.getSelectSql(), new SingleValueHandler(), this.generator.getPkColumnValue());
        if (nextId == null) {
            runner.update(this.getInsertSql(), this.generator.getPkColumnValue(), this.generator.getAllocationSize() + 1);
            this.nextId = 1L;
        } else {
            this.nextId = nextId.longValue();
            TableIdQueue tableIdQueue = this;
            tableIdQueue.nextId = tableIdQueue.nextId + (long)this.generator.getAllocationSize();
            runner.update(this.getUpdateSql(), this.nextId, this.generator.getPkColumnValue());
        }
        return this.nextId;
    }

    private String getSelectSql() {
        if (this.selectSql == null) {
            this.selectSql = "SELECT " + this.generator.getValueColumnName() + "\nFROM " + this.generator.getTable() + "\nWHERE " + this.generator.getPkColumnName() + " = ?";
        }
        return this.selectSql;
    }

    private String getUpdateSql() {
        if (this.updateSql == null) {
            this.updateSql = "UPDATE " + this.generator.getTable() + "\nSET " + this.generator.getValueColumnName() + " = ?" + "\nWHERE " + this.generator.getPkColumnName() + " = ?";
        }
        return this.updateSql;
    }
}

