/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.common.reflect;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.common.reflect.AbstractAccessor;
import org.batoo.jpa.common.reflect.ConstructorAccessor;
import org.batoo.jpa.common.reflect.FieldAccessor;
import org.batoo.jpa.common.reflect.MethodAccessor;
import org.batoo.jpa.common.reflect.PropertyDescriptor;
import org.batoo.jpa.common.reflect.SimpleConstructorAccessor;
import org.batoo.jpa.common.reflect.SunConstructorAccessor;
import org.batoo.jpa.common.reflect.UnsafeFieldAccessor;
import sun.misc.Unsafe;

public class ReflectHelper {
    private static final BLogger LOG = BLoggerFactory.getLogger(ReflectHelper.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    static final Unsafe unsafe = ReflectHelper.getUnSafe();

    public static Number convertNumber(Number value, Class<?> numberType) {
        if (numberType == Integer.class) {
            return value.intValue();
        }
        if (numberType == Long.class) {
            return value.longValue();
        }
        if (numberType == Short.class) {
            return value.shortValue();
        }
        if (numberType == Byte.class) {
            return value.byteValue();
        }
        if (numberType == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        if (numberType == Double.class) {
            return value.doubleValue();
        }
        throw new IllegalArgumentException(numberType + " not supported");
    }

    public static ConstructorAccessor createConstructor(Constructor<?> constructor) {
        try {
            Class.forName("sun.reflect.ConstructorAccessor");
        }
        catch (ClassNotFoundException e) {
            return new SimpleConstructorAccessor(constructor);
        }
        return ReflectHelper.createConstructorImpl(constructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConstructorAccessor createConstructorImpl(Constructor<?> constructor) {
        SunConstructorAccessor sunConstructorAccessor;
        Class<?> magClass = Class.forName("sun.reflect.MethodAccessorGenerator");
        Constructor<?> c = magClass.getDeclaredConstructors()[0];
        Method generateMethod = magClass.getMethod("generateConstructor", Class.class, Class[].class, Class[].class, Integer.TYPE);
        ReflectHelper.setAccessible(c, true);
        ReflectHelper.setAccessible(generateMethod, true);
        try {
            Object mag = c.newInstance(new Object[0]);
            sunConstructorAccessor = new SunConstructorAccessor(generateMethod.invoke(mag, constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers()));
        }
        catch (Throwable throwable) {
            try {
                ReflectHelper.setAccessible(c, false);
                ReflectHelper.setAccessible(generateMethod, false);
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Constructor generation failed", e);
            }
        }
        ReflectHelper.setAccessible(c, false);
        ReflectHelper.setAccessible(generateMethod, false);
        return sunConstructorAccessor;
    }

    public static String createMemberName(Member member) {
        return member.getDeclaringClass().getName() + "." + member.getName();
    }

    public static AbstractAccessor getAccessor(Member javaMember) {
        PropertyDescriptor[] descriptors;
        if (javaMember instanceof Field) {
            return unsafe != null ? new UnsafeFieldAccessor((Field)javaMember) : new FieldAccessor((Field)javaMember);
        }
        Class<?> clazz = javaMember.getDeclaringClass();
        for (PropertyDescriptor descriptor : descriptors = ReflectHelper.getProperties(clazz)) {
            if (descriptor.getReader() != javaMember) continue;
            return new MethodAccessor(descriptor.getReader(), descriptor.getWriter());
        }
        throw new BatooException("Method " + javaMember.getName() + " could not be found");
    }

    public static <A extends Annotation> A getAnnotation(Member member, Class<A> annotation) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(annotation);
        }
        if (member instanceof Method) {
            return ((Method)member).getAnnotation(annotation);
        }
        throw new IllegalArgumentException("Member is neither field nor method: " + member);
    }

    public static <X> Class<X> getGenericType(Member member, int index) {
        Type type;
        if (member instanceof Field) {
            Field field = (Field)member;
            type = field.getGenericType();
        } else {
            Method method = (Method)member;
            type = method.getGenericReturnType();
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] types = parameterizedType != null ? parameterizedType.getActualTypeArguments() : null;
        return (Class)(types != null && index < types.length ? types[index] : null);
    }

    public static Class<?> getMemberType(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        return ((Method)member).getReturnType();
    }

    public static PropertyDescriptor[] getProperties(Class<?> clazz) {
        Method[] methodList;
        ArrayList properties = Lists.newArrayList();
        for (Method method : methodList = clazz.getMethods()) {
            int mods;
            if (method == null || Modifier.isStatic(mods = method.getModifiers()) || !Modifier.isPublic(mods)) continue;
            String name = method.getName();
            if (method.getParameterTypes().length != 0) continue;
            if (name.startsWith(GET_PREFIX)) {
                new PropertyDescriptor(clazz, name.substring(3), method);
                continue;
            }
            if (method.getReturnType() != Boolean.TYPE || !name.startsWith(IS_PREFIX)) continue;
            new PropertyDescriptor(clazz, name.substring(2), method);
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Unsafe getUnSafe() {
        LOG.debug("Loading direct access library....");
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        try {
            Unsafe unsafe = (Unsafe)field.get(null);
            LOG.debug("Direct access library loaded successfully");
            return unsafe;
        }
        catch (Throwable throwable) {
            try {
                LOG.debug("Direct access library loaded successfully");
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Direct access library cannot be loaded");
                return null;
            }
        }
    }

    public static boolean isCollection(Class<?> type) {
        return List.class == type || Collection.class == type || Set.class == type || Map.class == type;
    }

    public static void setAccessible(final Member member, final boolean accessible) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (member instanceof Field) {
                    ((Field)member).setAccessible(accessible);
                } else if (member instanceof Method) {
                    ((Method)member).setAccessible(accessible);
                } else {
                    ((Constructor)member).setAccessible(accessible);
                }
                return null;
            }
        });
    }

    public static void warnAnnotations(BLogger logger, Member member, final Set<Class<? extends Annotation>> annotations) {
        final HashSet existing = member instanceof Field ? Sets.newHashSet((Object[])((Field)member).getAnnotations()) : Sets.newHashSet((Object[])((Field)member).getAnnotations());
        Set filtered = Sets.filter((Set)existing, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                for (Annotation annotation : existing) {
                    if (!annotations.contains(annotation.annotationType())) continue;
                    return false;
                }
                return true;
            }
        });
        if (filtered.size() > 0) {
            logger.warn("Following annotations on {0} were ignored: {1}", ReflectHelper.createMemberName(member), Joiner.on((String)", ").join((Iterable)filtered));
        }
    }
}

