/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.JtaEntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.PersistenceUtilImpl;
import org.batoo.jpa.parser.AndroidPersistenceParserImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.PersistenceParserImpl;

public class BatooPersistenceProvider
implements PersistenceProvider {
    private static final BLogger LOG = BLoggerFactory.getLogger(BatooPersistenceProvider.class);
    private final ProviderUtil providerUtil = new PersistenceUtilImpl();

    public EntityManagerFactoryImpl createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        try {
            PersistenceParserImpl parser = new PersistenceParserImpl(info, null);
            return StringUtils.isNotBlank((String)parser.getJtaDatasource()) ? new JtaEntityManagerFactoryImpl(info.getPersistenceUnitName(), parser) : new EntityManagerFactoryImpl(info.getPersistenceUnitName(), parser);
        }
        catch (Throwable e) {
            if (e instanceof PersistenceException || e instanceof MappingException || e instanceof BatooException) {
                throw (RuntimeException)e;
            }
            LOG.info(e, "Unable to find Batoo JPA persistence unit: " + info.getPersistenceUnitName());
            return null;
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        try {
            PersistenceParserImpl parser = new PersistenceParserImpl(emName);
            return new EntityManagerFactoryImpl(emName, parser);
        }
        catch (Throwable e) {
            if (e instanceof PersistenceException || e instanceof MappingException || e instanceof BatooException) {
                throw (RuntimeException)e;
            }
            LOG.info(e, "Unable to find Batoo JPA persistence unit: " + emName);
            return null;
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map<String, String> map, String[] classes) {
        try {
            AndroidPersistenceParserImpl parser = new AndroidPersistenceParserImpl(map, classes);
            return new EntityManagerFactoryImpl(emName, parser);
        }
        catch (Throwable e) {
            if (e instanceof PersistenceException || e instanceof MappingException || e instanceof BatooException) {
                throw (RuntimeException)e;
            }
            LOG.info(e, "Unable to build persistence unit: " + emName);
            return null;
        }
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }
}

