/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.WrappedIterator;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.util.BatooUtils;

public class ManagedSet<X, E>
extends ManagedCollection<E>
implements Set<E> {
    private final HashSet<E> delegate = Sets.newHashSet();
    private HashSet<E> snapshot;
    private boolean initialized;

    public ManagedSet(PluralMapping<?, ?, E> mapping, ManagedInstance<?> managedInstance, boolean lazy) {
        super(mapping, managedInstance);
        this.initialized = !lazy;
    }

    public ManagedSet(PluralMapping<?, ?, E> mapping, ManagedInstance<?> managedInstance, Collection<? extends E> values) {
        super(mapping, managedInstance);
        this.delegate.addAll(values);
        this.initialized = true;
    }

    @Override
    public boolean add(E e) {
        this.snapshot();
        if (this.delegate.add(e)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.snapshot();
        if (this.delegate.addAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean addChild(EntryImpl<Object, ManagedInstance<?>> child) {
        Object e = child.getValue().getInstance();
        if (!this.delegate.contains(e)) {
            return this.delegate.add(e);
        }
        return false;
    }

    @Override
    public boolean addElement(EntryImpl<Object, ?> child) {
        Object e = child.getValue();
        if (!this.delegate.contains(e)) {
            return this.delegate.add(e);
        }
        return false;
    }

    @Override
    public void clear() {
        this.snapshot();
        if (this.delegate.size() > 0) {
            this.changed();
        }
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        this.initialize();
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.initialize();
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        this.initialize();
        return this.delegate.equals(obj);
    }

    @Override
    public void flush(ConnectionImpl connection, boolean removals, boolean force) throws SQLException {
        if (this.removed(connection, removals)) {
            return;
        }
        ManagedInstance<?> managedInstance = this.getManagedInstance();
        PluralMapping mapping = this.getMapping();
        if (force) {
            for (E child : this.delegate) {
                mapping.attach(connection, managedInstance, null, child, -1);
            }
            return;
        }
        if (this.snapshot == null) {
            return;
        }
        if (removals) {
            Collection<E> childrenRemoved = BatooUtils.subtract(this.snapshot, this.delegate);
            for (E child : childrenRemoved) {
                mapping.detach(connection, managedInstance, null, child);
            }
        } else {
            Collection<E> childrenAdded = BatooUtils.subtract(this.delegate, this.snapshot);
            for (E child : childrenAdded) {
                mapping.attach(connection, managedInstance, null, child, -1);
            }
        }
    }

    @Override
    public Set<E> getDelegate() {
        return this.delegate;
    }

    @Override
    protected Collection<E> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public int hashCode() {
        this.initialize();
        return this.delegate.hashCode();
    }

    private void initialize() {
        if (!this.initialized) {
            if (this.getManagedInstance() == null) {
                throw new PersistenceException("No session to initialize the collection");
            }
            this.delegate.addAll(this.getMapping().loadCollection(this.getManagedInstance()));
            this.initialized = true;
        }
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Iterator<E> iterator() {
        this.initialize();
        return new WrappedIterator<E>(this.delegate.iterator()){

            @Override
            public void remove() {
                ManagedSet.this.snapshot();
                ManagedSet.this.changed();
                super.remove();
            }
        };
    }

    @Override
    public void refreshChildren() {
        this.reset();
        this.snapshot = null;
        this.delegate.clear();
        this.delegate.addAll(this.getMapping().loadCollection(this.getManagedInstance()));
    }

    @Override
    public boolean remove(Object o) {
        this.snapshot();
        if (this.delegate.remove(o)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.snapshot();
        if (this.delegate.removeAll(c)) {
            this.changed();
        }
        return false;
    }

    @Override
    protected void removeChild(E child) {
        this.delegate.remove(child);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.snapshot();
        if (this.delegate.retainAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        this.initialize();
        return this.delegate.size();
    }

    @Override
    protected void snapshot() {
        this.initialize();
        if (this.snapshot == null) {
            this.snapshot = Sets.newHashSet(this.delegate);
            this.reset();
        }
    }

    @Override
    public Object[] toArray() {
        this.initialize();
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.initialize();
        return this.delegate.toArray(a);
    }

    public String toString() {
        Object id = this.getManagedInstance().getId() != null ? this.getManagedInstance().getId().getId() : null;
        String instance = this.getManagedInstance().getType().getName() + "@" + id;
        return "ManagedSet [initialized=" + this.initialized + ", managedInstance=" + instance + ", delegate=" + this.delegate + ", snapshot=" + this.snapshot + ", mapping=" + this.getMapping() + "]";
    }
}

