/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQuery;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;

public abstract class BaseQueryImpl<T>
implements BaseQuery<T> {
    private final MetamodelImpl metamodel;
    private int nextEntityAlias;
    private int nextSelection;
    private int nextparam;
    private final HashMap<Selection<?>, String> selections = Maps.newHashMap();
    private final HashBiMap<ParameterExpressionImpl<?>, Integer> parameters = HashBiMap.create();
    private final HashMap<String, List<AbstractColumn>> fields = Maps.newHashMap();
    private String sql;
    private String jpql;
    private final List<ParameterExpressionImpl<?>> sqlParameters = Lists.newArrayList();

    public BaseQueryImpl(MetamodelImpl metamodel) {
        this.metamodel = metamodel;
    }

    @Override
    public String generateTableAlias(boolean entity) {
        return "E" + (!entity ? "C" : "") + this.nextEntityAlias++;
    }

    @Override
    public String getAlias(AbstractSelection<?> selection) {
        String alias = this.selections.get(selection);
        if (alias == null) {
            alias = "S" + this.nextSelection++;
            this.selections.put(selection, alias);
        }
        return alias;
    }

    @Override
    public Integer getAlias(ParameterExpressionImpl<?> parameter) {
        Integer alias = (Integer)this.parameters.get(parameter);
        if (alias == null) {
            alias = this.nextparam++;
            this.parameters.put(parameter, (Object)alias);
        }
        return alias;
    }

    @Override
    public String getFieldAlias(String tableAlias, AbstractColumn column) {
        int i;
        ArrayList fields = this.fields.get(tableAlias);
        if (fields == null) {
            fields = Lists.newArrayList();
            this.fields.put(tableAlias, fields);
        }
        if ((i = fields.indexOf(column)) >= 0) {
            return Integer.toString(i);
        }
        fields.add(column);
        return Integer.toString(fields.size() - 1);
    }

    @Override
    public JdbcAdaptor getJdbcAdaptor() {
        return this.metamodel.getJdbcAdaptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJpql() {
        if (this.jpql != null) {
            return this.jpql;
        }
        BaseQueryImpl baseQueryImpl = this;
        synchronized (baseQueryImpl) {
            if (this.jpql != null) {
                return this.jpql;
            }
            this.jpql = this.generateJpql();
            return this.jpql;
        }
    }

    @Override
    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    @Override
    public ParameterExpressionImpl<?> getParameter(int position) {
        return (ParameterExpressionImpl)this.parameters.inverse().get((Object)position);
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        HashSet parameters = Sets.newHashSet();
        parameters.addAll(this.parameters.keySet());
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSql() {
        if (this.sql != null) {
            return this.sql;
        }
        BaseQueryImpl baseQueryImpl = this;
        synchronized (baseQueryImpl) {
            if (this.sql != null) {
                return this.sql;
            }
            this.sql = this.generateSql();
            return this.sql;
        }
    }

    @Override
    public List<ParameterExpressionImpl<?>> getSqlParameters() {
        return this.sqlParameters;
    }

    public abstract boolean isQuery();

    @Override
    public int setNextSqlParam(ParameterExpressionImpl<?> parameter) {
        this.sqlParameters.add(parameter);
        return this.sqlParameters.size() - 1;
    }
}

