/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.Mapping;

public class CollectionExpression<C extends Collection<E>, E>
extends AbstractExpression<C> {
    private final ParentPath<?, ?> parentPath;
    private final Mapping<?, Collection<E>, E> mapping;

    public CollectionExpression(ParentPath<?, ?> parentPath, Mapping<?, Collection<E>, E> mapping) {
        super(mapping.getJavaType());
        this.parentPath = parentPath;
        this.mapping = mapping;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return this.parentPath.generateJpqlRestriction(query) + "." + this.mapping.getAttribute().getName();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection paths cannot be selected");
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection paths cannot be selected");
    }

    public Mapping<?, Collection<E>, E> getMapping() {
        return this.mapping;
    }

    public ParentPath<?, ?> getParentPath() {
        return this.parentPath;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        throw new IllegalArgumentException("Collection paths cannot be restricted");
    }

    @Override
    public C handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return null;
    }

    public String toString() {
        return "CollectionExpression [parentPath=" + this.parentPath + ", mapping=" + this.mapping + "]";
    }
}

