/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class LocateExpression
extends AbstractExpression<Integer> {
    private String alias;
    private final AbstractExpression<String> find;
    private final AbstractExpression<String> in;
    private final AbstractExpression<Integer> start;

    public LocateExpression(Expression<String> find, Expression<String> in, Expression<Integer> start) {
        super(Integer.class);
        this.find = (AbstractExpression)find;
        this.in = (AbstractExpression)in;
        this.start = (AbstractExpression)start;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder("locate(");
        builder.append(this.find.generateJpqlRestriction(query));
        builder.append(", ").append(this.in.generateJpqlRestriction(query));
        if (this.start != null) {
            builder.append(", ").append(this.start.generateJpqlRestriction(query));
        }
        return builder.append(")").toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder("LOCATE(");
        builder.append(this.find.getSqlRestrictionFragments(query)[0]);
        builder.append(", ").append(this.in.getSqlRestrictionFragments(query)[0]);
        if (this.start != null) {
            builder.append(", ").append(this.start.getSqlRestrictionFragments(query)[0]);
        }
        return new String[]{builder.append(")").toString()};
    }

    @Override
    public Integer handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (Integer)row.getObject(this.alias);
    }
}

