/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class SizeExpression<C>
extends AbstractExpression<Integer> {
    private final CollectionExpression<?, ?> collection;
    private String alias;

    public SizeExpression(Expression<C> collection) {
        super(Integer.class);
        this.collection = (CollectionExpression)collection;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "size(" + this.collection.generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        CriteriaBuilderImpl cb = query.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
        Joinable rp = this.collection.getParentPath().getRootPath();
        SubqueryImpl<Long> s = query.subquery(Long.class);
        Root<?> r = s.from(rp.getEntity());
        r.join(this.collection.getMapping().getAttribute().getName());
        s.where((Expression<Boolean>)cb.equal((Expression)r, (AbstractExpression)((Object)rp)));
        s.select(cb.count(cb.literal((Object)1)));
        return s.getSqlRestrictionFragments(query);
    }

    @Override
    public Integer handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return Long.valueOf(row.getLong(this.alias)).intValue();
    }
}

