/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class SubstringExpression
extends AbstractExpression<String> {
    private String alias;
    private final AbstractExpression<String> inner;
    private final AbstractExpression<Integer> start;
    private final AbstractExpression<Integer> end;

    public SubstringExpression(Expression<String> inner, Expression<Integer> start, Expression<Integer> end) {
        super(String.class);
        this.inner = (AbstractExpression)inner;
        this.start = (AbstractExpression)start;
        this.end = (AbstractExpression)end;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        if (this.end != null) {
            return "substring(" + this.inner.generateJpqlRestriction(query) + "," + this.start.generateJpqlRestriction(query) + ")";
        }
        return "substring(" + this.inner.generateJpqlRestriction(query) + "," + this.start.generateJpqlRestriction(query) + "," + this.end.generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String innerFragment = this.inner.getSqlRestrictionFragments(query)[0];
        String startFragment = this.start.getSqlRestrictionFragments(query)[0];
        String endFragment = this.end != null ? this.end.getSqlRestrictionFragments(query)[0] : null;
        return new String[]{query.getJdbcAdaptor().applySubStr(innerFragment, startFragment, endFragment)};
    }

    @Override
    public String handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (String)row.getObject(this.alias);
    }
}

