/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class TrimExpression
extends AbstractExpression<String> {
    private final CriteriaBuilder.Trimspec trimspec;
    private final AbstractExpression<Character> trimChar;
    private final AbstractExpression<String> inner;
    private String alias;

    public TrimExpression(CriteriaBuilder.Trimspec trimspec, Expression<Character> trimChar, Expression<String> inner) {
        super(String.class);
        this.trimspec = trimspec;
        this.trimChar = (AbstractExpression)trimChar;
        this.inner = (AbstractExpression)inner;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder("trim(");
        if (this.trimspec != null) {
            builder.append(this.trimspec.toString().toLowerCase(Locale.ENGLISH)).append(" ");
        }
        if (this.trimChar != null) {
            builder.append(this.trimChar.generateJpqlRestriction(query)).append(" ");
        }
        if (this.trimspec != null || this.trimChar != null) {
            builder.append("from ");
        }
        return builder.append(this.inner.generateJpqlRestriction(query)).append(")").toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String argument = this.inner.getSqlRestrictionFragments(query)[0];
        return new String[]{query.getJdbcAdaptor().applyTrim(this.trimspec, this.trimChar != null ? this.trimChar.getSqlRestrictionFragments(query)[0] : null, argument)};
    }

    @Override
    public String handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (String)row.getObject(this.alias);
    }
}

