/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.jpql;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.PluralJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQuery;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaDeleteImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaUpdateImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.RootImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.AllAnyExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConcatExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConstantExpression;
import org.batoo.jpa.core.impl.criteria.expression.CountExpression;
import org.batoo.jpa.core.impl.criteria.expression.ExistsExpression;
import org.batoo.jpa.core.impl.criteria.expression.FunctionExpression;
import org.batoo.jpa.core.impl.criteria.expression.MapExpression;
import org.batoo.jpa.core.impl.criteria.expression.NullIfExpression;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.criteria.expression.SubstringExpression;
import org.batoo.jpa.core.impl.criteria.expression.TrimExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.criteria.join.ListJoinImpl;
import org.batoo.jpa.core.impl.criteria.jpql.Aliased;
import org.batoo.jpa.core.impl.criteria.jpql.Qualified;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.jpql.JpqlLexer;
import org.batoo.jpa.jpql.JpqlParser;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class JpqlQuery {
    private static final BLogger LOG = BLoggerFactory.getLogger(JpqlQuery.class);
    private final MetamodelImpl metamodel;
    private final String qlString;
    private final BaseQuery<?> q;
    private final Map<BaseQuery<?>, Map<String, AbstractFrom<?, ?>>> aliasMap = Maps.newHashMap();
    private HashMap<String, Object> hints;
    private LockModeType lockMode;
    private long lastUsed;

    public JpqlQuery(EntityManagerFactoryImpl entityManagerFactory, CriteriaBuilderImpl cb, NamedQueryMetadata metadata) {
        this(entityManagerFactory, metadata.getQuery(), cb);
        this.lastUsed = Long.MAX_VALUE;
        this.q.getSql();
        this.lockMode = metadata.getLockMode();
        if (metadata.getHints().size() > 0) {
            this.hints = Maps.newHashMap();
            this.hints.putAll(metadata.getHints());
        }
        entityManagerFactory.addNamedQuery(metadata.getName(), this);
    }

    public JpqlQuery(EntityManagerFactoryImpl entityManagerFactory, String qlString) {
        this(entityManagerFactory, qlString, null);
    }

    private JpqlQuery(EntityManagerFactoryImpl entityManagerFactory, String qlString, CriteriaBuilderImpl cb) {
        this.metamodel = entityManagerFactory.getMetamodel();
        this.qlString = qlString;
        this.lastUsed = System.currentTimeMillis();
        if (cb == null) {
            cb = entityManagerFactory.getCriteriaBuilder();
        }
        this.q = this.parse(cb);
    }

    private BaseQueryImpl<?> construct(CriteriaBuilderImpl cb, CommonTree tree) {
        Tree type = tree.getChild(0);
        if (type.getType() == 110) {
            return this.constructSelectQuery(cb, tree);
        }
        if (type.getType() == 33) {
            return this.constructDeleteQuery(cb, tree);
        }
        return this.constructUpdateQuery(cb, tree);
    }

    private CriteriaDeleteImpl constructDeleteQuery(CriteriaBuilderImpl cb, CommonTree tree) {
        CriteriaDeleteImpl<Object> q = new CriteriaDeleteImpl<Object>(this.metamodel);
        Tree deleteDef = tree.getChild(0);
        Tree aliasedDef = deleteDef.getChild(0);
        Aliased aliased = new Aliased(aliasedDef);
        EntityTypeImpl<Object> entity = this.getEntity(aliased.getQualified().toString());
        RootImpl r = (RootImpl)q.from(entity);
        this.putAlias(q, aliasedDef, aliased, r);
        if (tree.getChildCount() == 2) {
            q.where((Expression)this.constructJunction(cb, q, deleteDef.getChild(1)));
        }
        Tree setDefs = tree.getChild(1);
        for (int i = 0; i < setDefs.getChildCount(); ++i) {
            Tree setDef = setDefs.getChild(i);
            this.getExpression(cb, q, setDef.getChild(0), null);
        }
        return q;
    }

    private void constructFrom(CriteriaBuilderImpl cb, AbstractQuery<?> q, Tree froms) {
        for (int i = 0; i < froms.getChildCount(); ++i) {
            RootImpl r;
            EntityTypeImpl<Object> entity;
            Aliased fromDef;
            Tree from = froms.getChild(i);
            if (from.getType() == 156) {
                fromDef = new Aliased(from.getChild(0));
                entity = this.getEntity(fromDef.getQualified().toString());
                r = (RootImpl)q.from(entity);
                r.alias(fromDef.getAlias());
                this.putAlias((BaseQueryImpl)q, from, fromDef, r);
                this.constructJoins(cb, (AbstractCriteriaQueryImpl)q, r, from.getChild(1));
                continue;
            }
            if (from.getType() == 153) {
                Aliased aliased = new Aliased(from.getChild(1));
                Join parent = this.getAliased(q, from.getChild(0).getText());
                int depth = 0;
                for (String segment : aliased.getQualified().getSegments()) {
                    if (depth > 0 && parent instanceof PluralJoin) {
                        throw new PersistenceException("Cannot qualify, only embeddable joins within the path allowed, line " + from.getLine() + ":" + from.getCharPositionInLine());
                    }
                    parent = parent.join(segment, JoinType.LEFT);
                    ++depth;
                }
                parent.alias(aliased.getAlias());
                this.putAlias((BaseQueryImpl)q, from.getChild(1), aliased, (AbstractFrom<?, ?>)parent);
                continue;
            }
            fromDef = new Aliased(from);
            entity = this.getEntity(fromDef.getQualified().toString());
            r = (RootImpl)q.from(entity);
            r.alias(fromDef.getAlias());
            this.putAlias((BaseQuery)q, from, fromDef, r);
        }
    }

    private List<Expression<?>> constructGroupBy(CriteriaBuilderImpl cb, AbstractQuery<?> q, Tree groupByDef) {
        ArrayList groupBy = Lists.newArrayList();
        for (int i = 0; i < groupByDef.getChildCount(); ++i) {
            groupBy.add(this.getExpression(cb, q, groupByDef.getChild(i), null));
        }
        return groupBy;
    }

    private void constructJoins(CriteriaBuilderImpl cb, AbstractCriteriaQueryImpl<?> q, RootImpl<Object> r, Tree joins) {
        for (int i = 0; i < joins.getChildCount(); ++i) {
            Tree join = joins.getChild(i);
            int joinType = join.getChild(0).getType();
            if (joinType == 48) {
                Fetch parent = this.getAliased(q, join.getChild(1).getText());
                Qualified qualified = new Qualified(join.getChild(2));
                for (String segment : qualified.getSegments()) {
                    parent = parent.fetch(segment);
                }
                continue;
            }
            Aliased aliased = new Aliased(join.getChild(2));
            Join parent = this.getAliased(q, join.getChild(1).getText());
            int depth = 0;
            for (String segment : aliased.getQualified().getSegments()) {
                if (depth > 0 && parent instanceof PluralJoin) {
                    throw new PersistenceException("Cannot qualify, only embeddable joins within the path allowed, line " + join.getLine() + ":" + join.getCharPositionInLine());
                }
                parent = joinType == 69 ? parent.join(segment, JoinType.LEFT) : parent.join(segment, JoinType.INNER);
                ++depth;
            }
            parent.alias(aliased.getAlias());
            this.putAlias((BaseQuery<?>)q, join.getChild(1), aliased, (AbstractFrom<?, ?>)parent);
        }
    }

    private Expression<Boolean> constructJunction(CriteriaBuilderImpl cb, Object q, Tree junctionDef) {
        ArrayList predictions = Lists.newArrayList();
        for (int i = 0; i < junctionDef.getChildCount(); ++i) {
            Tree childDef = junctionDef.getChild(i);
            if (childDef.getType() == 145 || childDef.getType() == 140) {
                predictions.add(this.constructJunction(cb, q, childDef));
                continue;
            }
            predictions.add(this.constructPredicate(cb, q, childDef));
        }
        if (predictions.size() == 1) {
            return (Expression)predictions.get(0);
        }
        if (junctionDef.getType() == 145) {
            return cb.or(predictions.toArray(new Predicate[predictions.size()]));
        }
        return cb.and(predictions.toArray(new Predicate[predictions.size()]));
    }

    private void constructOrder(CriteriaBuilderImpl cb, CriteriaQueryImpl<?> q, Tree orderBy) {
        ArrayList orders = Lists.newArrayList();
        for (int i = 0; i < orderBy.getChildCount(); ++i) {
            Tree orderByItem = orderBy.getChild(i);
            Order order = orderByItem.getChildCount() == 2 ? cb.desc(this.getExpression(cb, q, orderByItem.getChild(0), null)) : cb.asc(this.getExpression(cb, q, orderByItem.getChild(0), null));
            orders.add(order);
        }
        q.orderBy(orders);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <X> Expression<Boolean> constructPredicate(CriteriaBuilderImpl cb, Object q, Tree predictionDef) {
        AbstractExpression<X> left;
        if (predictionDef.getType() == 45 || predictionDef.getType() == 93 || predictionDef.getType() == 54 || predictionDef.getType() == 53 || predictionDef.getType() == 77 || predictionDef.getType() == 76 || predictionDef.getType() == 13) {
            AbstractExpression<X> right;
            if (predictionDef.getChild(0).getType() == 168 || predictionDef.getChild(1).getType() == 168) {
                if (predictionDef.getChild(0).getType() == 168) {
                    right = this.getExpression(cb, q, predictionDef.getChild(1), null);
                    left = this.constructSubquery(cb, q, predictionDef.getChild(0), right.getJavaType());
                } else {
                    if (predictionDef.getChild(1).getType() != 168) throw new PersistenceException("Both sides of the comparison cannot be sub query, line " + predictionDef.getLine() + ":" + predictionDef.getCharPositionInLine());
                    left = this.getExpression(cb, q, predictionDef.getChild(0), null);
                    right = this.constructSubquery(cb, q, predictionDef.getChild(1), left.getJavaType());
                }
            } else {
                left = this.getExpression(cb, q, predictionDef.getChild(0), null);
                right = this.getExpression(cb, q, predictionDef.getChild(1), left.getJavaType());
            }
            switch (predictionDef.getType()) {
                case 45: {
                    return cb.equal((Expression)left, right);
                }
                case 93: {
                    return cb.notEqual((Expression)left, right);
                }
                case 54: {
                    if (!Comparable.class.isAssignableFrom(left.getJavaType())) return cb.gt((Expression)left, right);
                    return cb.greaterThan((Expression)left, right);
                }
                case 53: {
                    if (!Comparable.class.isAssignableFrom(left.getJavaType())) return cb.ge((Expression)left, right);
                    return cb.greaterThanOrEqualTo((Expression)left, right);
                }
                case 77: {
                    if (!Comparable.class.isAssignableFrom(left.getJavaType())) return cb.lt((Expression)left, right);
                    return cb.lessThan((Expression)left, right);
                }
                case 76: {
                    if (!Comparable.class.isAssignableFrom(left.getJavaType())) return cb.le((Expression)left, right);
                    return cb.lessThanOrEqualTo(left, right);
                }
                case 13: {
                    AbstractExpression right2 = this.getExpression(cb, q, predictionDef.getChild(2), left.getJavaType());
                    Predicate between = cb.between(left, right, right2);
                    if (predictionDef.getChildCount() != 4) return between;
                    return between.not();
                }
            }
        }
        if (predictionDef.getType() == 71) {
            AbstractExpression<String> inner = this.getExpression(cb, q, predictionDef.getChild(0), String.class);
            AbstractExpression<String> pattern = this.getExpression(cb, q, predictionDef.getChild(1), String.class);
            if (predictionDef.getChildCount() > 2 && predictionDef.getChild(2).getType() == 115) {
                AbstractExpression<Character> escape = this.getExpression(cb, q, predictionDef.getChild(2), Character.class);
                if (predictionDef.getChild(predictionDef.getChildCount() - 1).getType() != 88) return cb.like((Expression)inner, (Expression)pattern, (Expression)escape);
                return cb.notLike((Expression)inner, (Expression)pattern, (Expression)escape);
            }
            if (predictionDef.getChild(predictionDef.getChildCount() - 1).getType() != 88) return cb.like((Expression)inner, pattern);
            return cb.notLike((Expression)inner, pattern);
        }
        if (predictionDef.getType() == 159) {
            left = null;
            if (predictionDef.getChild(0).getType() != 92 && predictionDef.getChild(0).getType() != 100) {
                left = this.getExpression(cb, q, predictionDef.getChild(0), null);
            }
            ArrayList expressions = Lists.newArrayList();
            Tree inDefs = predictionDef.getChild(1);
            for (int i = 0; i < inDefs.getChildCount(); ++i) {
                expressions.add(this.getExpression(cb, q, inDefs.getChild(i), left != null ? left.getJavaType() : null));
            }
            if (left != null) return left.in(expressions);
            left = this.getExpression(cb, q, predictionDef.getChild(0), ((AbstractExpression)expressions.get(0)).getJavaType());
            return left.in(expressions);
        }
        if (predictionDef.getType() != 163) return this.getExpression(cb, q, predictionDef, Boolean.class);
        AbstractExpression<X> expr = this.getExpression(cb, q, predictionDef.getChild(0), null);
        if (predictionDef.getChildCount() != 2) return cb.isNull(expr);
        return cb.isNotNull(expr);
    }

    private List<Selection<?>> constructSelect(CriteriaBuilderImpl cb, CriteriaQueryImpl<?> q, Tree selects) {
        ArrayList selections = Lists.newArrayList();
        for (int i = 0; i < selects.getChildCount(); ++i) {
            Tree selectDef = selects.getChild(i);
            AbstractSelection<?> selection = this.constructSingleSelect(cb, q, selectDef.getChild(0));
            if (selectDef.getChildCount() == 2) {
                selection.alias(selectDef.getChild(1).getText());
            }
            selections.add(selection);
        }
        q.updateResultClass(selections);
        return selections;
    }

    private CriteriaQueryImpl constructSelectQuery(CriteriaBuilderImpl cb, CommonTree tree) {
        Tree child;
        CriteriaQueryImpl q = new CriteriaQueryImpl(this.metamodel);
        this.constructFrom(cb, q, tree.getChild(1));
        Tree select = tree.getChild(0);
        List<Selection<?>> selections = this.constructSelect(cb, q, select.getChild(select.getChildCount() - 1));
        if (selections.size() == 1) {
            q.select((Selection)selections.get(0));
        } else {
            q.multiselect(selections);
        }
        if (select.getChild(0).getType() == 35) {
            q.distinct(true);
        }
        int i = 2;
        while ((child = tree.getChild(i)).getType() != -1) {
            if (child.getType() == 134) {
                q.where((Expression)this.constructJunction(cb, q, child.getChild(0)));
            }
            if (child.getType() == 142) {
                q.groupBy(this.constructGroupBy(cb, q, child));
            }
            if (child.getType() == 56) {
                q.having(this.constructJunction(cb, q, child.getChild(0)));
            }
            if (child.getType() == 146) {
                this.constructOrder(cb, q, child);
            }
            ++i;
        }
        return q;
    }

    private AbstractSelection<?> constructSingleSelect(CriteriaBuilderImpl cb, CriteriaQueryImpl<?> q, Tree selectDef) {
        if (selectDef.getType() == 87) {
            String className = new Qualified(selectDef.getChild(0)).toString();
            ArrayList childSelections = Lists.newArrayList();
            Tree arguments = selectDef.getChild(1);
            for (int i = 0; i < arguments.getChildCount(); ++i) {
                Tree argumentDef = arguments.getChild(i);
                childSelections.add(this.getExpression(cb, q, argumentDef, null));
            }
            try {
                return cb.construct(Class.forName(className.toString()), childSelections.toArray(new Selection[childSelections.size()]));
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Cannot load class: " + className + ", line " + selectDef.getLine() + ":" + selectDef.getCharPositionInLine());
            }
        }
        if (selectDef.getType() == 95) {
            String alias = selectDef.getChild(0).getText();
            return this.getAliased(q, alias);
        }
        return this.getExpression(cb, q, selectDef, null);
    }

    private <T> SubqueryImpl<T> constructSubquery(CriteriaBuilderImpl cb, Object q, Tree subQueryDef, Class<T> javaType) {
        SubqueryImpl<T> s = q instanceof CriteriaQueryImpl ? ((CriteriaQueryImpl)q).subquery(javaType) : (q instanceof CriteriaUpdateImpl ? ((CriteriaUpdateImpl)q).subquery(javaType) : ((CriteriaDeleteImpl)q).subquery(javaType));
        Tree type = subQueryDef.getChild(0);
        if (type.getType() == 110) {
            Tree child;
            this.constructFrom(cb, (AbstractQuery<?>)s, subQueryDef.getChild(1));
            Tree selectDef = subQueryDef.getChild(0).getChild(0);
            s.select(this.getExpression(cb, s, selectDef, javaType));
            if (subQueryDef.getChild(1).getType() == 35) {
                s.distinct(true);
            }
            int i = 2;
            while ((child = subQueryDef.getChild(i)) != null) {
                if (child.getType() == 134) {
                    s.where(this.constructJunction(cb, s, child.getChild(0)));
                }
                if (child.getType() == 142) {
                    s.groupBy((List)this.constructGroupBy(cb, (AbstractQuery<?>)s, child));
                }
                if (child.getType() == 56) {
                    s.having((Expression)this.constructJunction(cb, s, child.getChild(0)));
                }
                ++i;
            }
        }
        return s;
    }

    private CriteriaUpdateImpl<?> constructUpdateQuery(CriteriaBuilderImpl cb, CommonTree tree) {
        CriteriaUpdateImpl<Object> q = new CriteriaUpdateImpl<Object>(this.metamodel);
        Tree deleteDef = tree.getChild(0);
        Tree aliasedDef = deleteDef.getChild(0);
        Aliased aliased = new Aliased(aliasedDef);
        EntityTypeImpl<Object> entity = this.getEntity(aliased.getQualified().toString());
        RootImpl r = (RootImpl)q.from(entity);
        this.putAlias(q, aliasedDef, aliased, r);
        Tree setDefs = tree.getChild(1);
        for (int i = 0; i < setDefs.getChildCount(); ++i) {
            Tree setDef = setDefs.getChild(i);
            this.getExpression(cb, q, setDef.getChild(0), null);
        }
        return q;
    }

    public <T> QueryImpl<T> createTypedQuery(EntityManagerImpl entityManager) {
        if (this.lastUsed != Long.MAX_VALUE) {
            this.lastUsed = System.currentTimeMillis();
        }
        QueryImpl typedQuery = new QueryImpl(this.q, entityManager);
        if (this.lockMode != null) {
            typedQuery.setLockMode(this.lockMode);
        }
        if (this.hints != null) {
            for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
                typedQuery.setHint(entry.getKey(), entry.getValue());
            }
        }
        return typedQuery;
    }

    private AbstractFrom<?, ?> getAliased(Object q, String alias) {
        AbstractFrom<?, ?> from;
        Map<String, AbstractFrom<?, ?>> aliasMap = this.aliasMap.get(q);
        if (aliasMap != null && (from = aliasMap.get(alias)) != null) {
            return from;
        }
        if (q instanceof Subquery) {
            SubqueryImpl s = (SubqueryImpl)q;
            AbstractFrom<?, ?> aliased = this.getAliased(s.getParent(), alias);
            if (aliased instanceof RootImpl) {
                s.correlate((RootImpl)aliased);
            }
            return aliased;
        }
        throw new PersistenceException("Alias is not bound: " + alias);
    }

    private EntityTypeImpl<Object> getEntity(String entityName) {
        EntityTypeImpl<Object> entity = this.metamodel.entity(entityName);
        if (entity == null) {
            throw new PersistenceException("Type is not managed: " + entityName);
        }
        return entity;
    }

    private <X, C extends Collection<E>, E> AbstractExpression<X> getExpression(CriteriaBuilderImpl cb, Object q, Tree exprDef, Class<X> javaType) {
        CollectionExpression collection;
        AbstractExpression<X> expression;
        ArrayList arguments;
        AbstractExpression right;
        AbstractExpression<X> left;
        if (exprDef.getType() == 58) {
            return this.getAliased(q, exprDef.getText());
        }
        if (exprDef.getType() == 165) {
            AbstractExpression expression2 = this.getAliased(q, exprDef.getChild(0).getText());
            Qualified qualified = new Qualified(exprDef.getChild(1));
            for (String segment : qualified.getSegments()) {
                if (expression2 instanceof ParentPath) {
                    expression2 = ((ParentPath)expression2).getExpression(segment);
                    continue;
                }
                throw new PersistenceException("Cannot dereference: " + segment + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            return expression2;
        }
        if (exprDef.getType() == 162) {
            return (AbstractExpression)cb.neg(this.getExpression(cb, q, exprDef.getChild(0), null));
        }
        if (exprDef.getType() == 92) {
            return cb.parameter((Class)javaType, exprDef.getText().substring(1));
        }
        if (exprDef.getType() == 100) {
            return cb.parameter((Class)javaType, exprDef.getText().substring(1));
        }
        if (exprDef.getType() == 104 || exprDef.getType() == 84 || exprDef.getType() == 85 || exprDef.getType() == 36) {
            left = this.getExpression(cb, q, exprDef.getChild(0), null);
            right = this.getExpression(cb, q, exprDef.getChild(1), left.getJavaType());
            switch (exprDef.getType()) {
                case 104: {
                    return (AbstractExpression)cb.sum(left, right);
                }
                case 84: {
                    return (AbstractExpression)cb.diff(left, right);
                }
                case 85: {
                    return (AbstractExpression)cb.prod(left, right);
                }
                case 36: {
                    return (AbstractExpression)cb.quot(left, right);
                }
            }
        }
        if (exprDef.getType() == 151) {
            return this.getExpression(cb, q, exprDef, Boolean.class);
        }
        if (exprDef.getType() == 91) {
            return new ConstantExpression<Long>(this.metamodel.createBasicType(Long.class), Long.valueOf(exprDef.getText()));
        }
        if (exprDef.getType() == 115) {
            if (javaType == Character.class) {
                return new ConstantExpression<Character>(this.metamodel.type(Character.class), Character.valueOf(exprDef.getText().substring(1, 2).toCharArray()[0]));
            }
            return new ConstantExpression<String>(this.metamodel.type(String.class), exprDef.getText().substring(1, exprDef.getText().length() - 1));
        }
        if (exprDef.getType() == 128 || exprDef.getType() == 74 || exprDef.getType() == 116) {
            AbstractExpression<String> argument = this.getExpression(cb, q, exprDef.getChild(0), null);
            switch (exprDef.getType()) {
                case 128: {
                    return (AbstractExpression)cb.upper(argument);
                }
                case 74: {
                    return (AbstractExpression)cb.lower(argument);
                }
                case 116: {
                    AbstractExpression<Integer> start = this.getExpression(cb, q, exprDef.getChild(1), Integer.class);
                    AbstractExpression<Integer> end = exprDef.getChildCount() == 3 ? this.getExpression(cb, q, exprDef.getChild(2), Integer.class) : null;
                    return new SubstringExpression(argument, start, end);
                }
            }
        }
        if (exprDef.getType() == 24) {
            arguments = Lists.newArrayList();
            for (int i = 0; i < exprDef.getChildCount(); ++i) {
                arguments.add(this.getExpression(cb, q, exprDef.getChild(i), String.class));
            }
            return new ConcatExpression(arguments.toArray(new Expression[arguments.size()]));
        }
        if (exprDef.getType() == 122) {
            CriteriaBuilder.Trimspec trimspec = null;
            AbstractExpression<Character> trimChar = null;
            AbstractExpression<String> inner = null;
            int i = 0;
            int type = exprDef.getChild(i).getType();
            if (type == 15) {
                trimspec = CriteriaBuilder.Trimspec.BOTH;
                ++i;
            } else if (type == 68) {
                trimspec = CriteriaBuilder.Trimspec.LEADING;
                ++i;
            } else if (type == 121) {
                trimspec = CriteriaBuilder.Trimspec.TRAILING;
                ++i;
            }
            if (exprDef.getChildCount() > i + 1) {
                trimChar = this.getExpression(cb, q, exprDef.getChild(i), Character.class);
                inner = this.getExpression(cb, q, exprDef.getChild(i + 1), String.class);
            } else {
                inner = this.getExpression(cb, q, exprDef.getChild(i), String.class);
            }
            return new TrimExpression(trimspec, trimChar, inner);
        }
        if (exprDef.getType() == 124 || exprDef.getType() == 155) {
            switch (exprDef.getType()) {
                case 124: {
                    AbstractExpression<X> inner = this.getExpression(cb, q, exprDef.getChild(0), null);
                    return (AbstractExpression)((AbstractPath)inner).type();
                }
                case 155: {
                    EntityTypeImpl<Object> entity = this.getEntity(exprDef.getChild(0).getText());
                    if (entity.getRootType().getInheritanceType() == null) {
                        throw new PersistenceException("Entity does not have inheritence: " + entity.getName() + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
                    }
                    return new ConstantExpression<String>(null, entity.getDiscriminatorValue());
                }
            }
        }
        switch (exprDef.getType()) {
            case 26: {
                return cb.currentDate();
            }
            case 27: {
                return (AbstractExpression)cb.currentTime();
            }
            case 28: {
                return (AbstractExpression)cb.currentTimestamp();
            }
        }
        switch (exprDef.getType()) {
            case 5: {
                return (AbstractExpression)cb.abs(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 114: {
                return (AbstractExpression)cb.sqrt(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 83: {
                return (AbstractExpression)cb.mod(this.getExpression(cb, q, exprDef.getChild(0), Integer.class), this.getExpression(cb, q, exprDef.getChild(1), Integer.class));
            }
            case 73: {
                if (exprDef.getChildCount() == 3) {
                    return (AbstractExpression)cb.locate(this.getExpression(cb, q, exprDef.getChild(0), String.class), this.getExpression(cb, q, exprDef.getChild(1), String.class), this.getExpression(cb, q, exprDef, Integer.class));
                }
                return (AbstractExpression)cb.locate(this.getExpression(cb, q, exprDef.getChild(0), String.class), this.getExpression(cb, q, exprDef.getChild(1), String.class));
            }
            case 70: {
                return (AbstractExpression)cb.length(this.getExpression(cb, q, exprDef.getChild(0), String.class));
            }
        }
        switch (exprDef.getType()) {
            case 11: {
                return (AbstractExpression)cb.avg(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 117: {
                return (AbstractExpression)cb.sum(this.getExpression(cb, q, exprDef.getChild(0), Long.class));
            }
            case 80: {
                return (AbstractExpression)cb.max(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
            case 82: {
                return (AbstractExpression)cb.min(this.getExpression(cb, q, exprDef.getChild(0), Number.class));
            }
        }
        if (exprDef.getType() == 25) {
            if (exprDef.getChildCount() == 2) {
                return new CountExpression(this.getExpression(cb, q, exprDef.getChild(1), null), true);
            }
            return new CountExpression(this.getExpression(cb, q, exprDef.getChild(0), null), false);
        }
        if (exprDef.getType() == 150) {
            switch (exprDef.getChild(0).getType()) {
                case 6: {
                    return new AllAnyExpression<X>(true, this.constructSubquery(cb, q, exprDef.getChild(1), javaType));
                }
                case 8: 
                case 113: {
                    return new AllAnyExpression<X>(false, this.constructSubquery(cb, q, exprDef.getChild(1), javaType));
                }
            }
        }
        if (exprDef.getType() == 43) {
            return new ExistsExpression(this.constructSubquery(cb, q, exprDef.getChild(0), javaType));
        }
        if (exprDef.getType() == 88) {
            return new PredicateImpl(true, Predicate.BooleanOperator.AND, this.getExpression(cb, q, exprDef.getChild(0), Boolean.class));
        }
        if (exprDef.getType() == 157) {
            CriteriaBuilder.Case caseExpr = cb.selectCase();
            for (int i = 0; i < exprDef.getChildCount(); ++i) {
                Tree caseDef = exprDef.getChild(i);
                if (caseDef.getType() == 133) {
                    caseExpr.when(this.constructJunction(cb, q, caseDef.getChild(0)), this.getExpression(cb, q, caseDef.getChild(1), null));
                    continue;
                }
                caseExpr.otherwise(this.getExpression(cb, q, caseDef, null));
            }
            return caseExpr;
        }
        if (exprDef.getType() == 18) {
            expression = this.getExpression(cb, q, exprDef.getChild(0), null);
            CriteriaBuilder.SimpleCase caseExpr = cb.selectCase(expression);
            for (int i = 1; i < exprDef.getChildCount(); ++i) {
                Tree caseDef = exprDef.getChild(i);
                if (caseDef.getType() == 133) {
                    AbstractExpression<X> condition;
                    AbstractExpression<X> result = this.getExpression(cb, q, caseDef.getChild(1), null);
                    if (exprDef.getChild(0).getType() == 124) {
                        EntityTypeImpl<Object> entity = this.getEntity(caseDef.getChild(0).getText());
                        if (entity.getRootType().getInheritanceType() == null) {
                            throw new PersistenceException("Entity does not have inheritence: " + entity.getName() + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
                        }
                        condition = new ConstantExpression<String>(null, entity.getDiscriminatorValue());
                    } else {
                        condition = this.getExpression(cb, q, caseDef.getChild(0), null);
                    }
                    caseExpr.when(condition, result);
                    continue;
                }
                caseExpr.otherwise(this.getExpression(cb, q, caseDef, null));
            }
            return caseExpr;
        }
        if (exprDef.getType() == 90) {
            left = this.getExpression(cb, q, exprDef.getChild(0), null);
            right = this.getExpression(cb, q, exprDef.getChild(1), null);
            return new NullIfExpression<X>(left, right);
        }
        if (exprDef.getType() == 152) {
            CriteriaBuilder.Coalesce coalesce = cb.coalesce();
            for (int i = 0; i < exprDef.getChildCount(); ++i) {
                coalesce.value(this.getExpression(cb, q, exprDef.getChild(i), javaType));
            }
            return coalesce;
        }
        if (exprDef.getType() == 50) {
            arguments = Lists.newArrayList();
            String function = exprDef.getChild(0).getText();
            for (int i = 1; i < exprDef.getChildCount(); ++i) {
                arguments.add(this.getExpression(cb, q, exprDef.getChild(i), null));
            }
            return new FunctionExpression<X>(javaType != null ? javaType : Object.class, function, arguments.toArray(new Expression[arguments.size()]));
        }
        if (exprDef.getType() == 60) {
            expression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (expression instanceof ListJoinImpl) {
                return (AbstractExpression)((ListJoinImpl)expression).index();
            }
            throw new PersistenceException("Reference is not a list join, line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
        }
        if (exprDef.getType() == 154) {
            expression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (expression instanceof MapExpression) {
                expression = ((MapExpression)expression).values();
            }
            if (!(expression instanceof CollectionExpression)) {
                throw new PersistenceException("Reference is not a collection, line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            if (exprDef.getChildCount() == 2) {
                return (AbstractExpression)cb.isNotEmpty(expression);
            }
            return (AbstractExpression)cb.isEmpty(expression);
        }
        if (exprDef.getType() == 161) {
            expression = this.getExpression(cb, q, exprDef.getChild(1), null);
            if (!(expression instanceof CollectionExpression)) {
                throw new PersistenceException("Member of expression must evaluate to a collection expression, " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            collection = (CollectionExpression)expression;
            PluralAttributeImpl attribute = (PluralAttributeImpl)collection.getMapping().getAttribute();
            AbstractExpression elem = this.getExpression(cb, q, exprDef.getChild(0), attribute.getElementType().getJavaType());
            if (exprDef.getChildCount() == 3) {
                return (AbstractExpression)cb.isNotMember(elem, collection);
            }
            return (AbstractExpression)cb.isMember(elem, collection);
        }
        if (exprDef.getType() == 112) {
            expression = this.getExpression(cb, q, exprDef.getChild(0), null);
            if (!(expression instanceof CollectionExpression)) {
                throw new PersistenceException("Member of expression must evaluate to a collection expression, " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
            }
            collection = (CollectionExpression)expression;
            return (AbstractExpression)cb.size(collection);
        }
        throw new PersistenceException("Unhandled expression: " + exprDef.toStringTree() + ", line " + exprDef.getLine() + ":" + exprDef.getCharPositionInLine());
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public String getQueryString() {
        return this.qlString;
    }

    private BaseQueryImpl<?> parse(CriteriaBuilderImpl cb) {
        CommonTree tree = this.parse(this.qlString);
        LOG.debug("Parsed query successfully {0}", LOG.lazyBoxed(this.qlString, new Object[]{tree.toStringTree()}));
        return this.construct(cb, tree);
    }

    private CommonTree parse(String query) {
        try {
            JpqlLexer lexer = new JpqlLexer((CharStream)new ANTLRStringStream(query));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            JpqlParser parser = new JpqlParser((TokenStream)tokenStream);
            JpqlParser.ql_statement_return ql_statement = parser.ql_statement();
            CommonTree tree = (CommonTree)ql_statement.getTree();
            List<String> errors = parser.getErrors();
            if (errors.size() > 0) {
                String errorMsg = Joiner.on((String)"\n\t").join(errors);
                LOG.error("Cannot parse query: {0}", LOG.boxed(query, new Object[]{"\n\t" + errorMsg, "\n\n" + tree.toStringTree() + "\n"}));
                throw new PersistenceException("cannot parse the query:\n " + errorMsg);
            }
            return tree;
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot parse jpql: " + e.getMessage(), (Throwable)e);
        }
    }

    private void putAlias(BaseQuery<?> q, Tree aliasedDef, Aliased aliased, AbstractFrom<?, ?> r) {
        String alias;
        HashMap aliasMap = this.aliasMap.get(q);
        if (aliasMap == null) {
            aliasMap = Maps.newHashMap();
            this.aliasMap.put(q, aliasMap);
        }
        if (aliasMap.containsKey(alias = aliased.getAlias())) {
            throw new PersistenceException("Alias already exists: " + alias + ", line " + aliasedDef.getLine() + ":" + aliasedDef.getCharPositionInLine());
        }
        aliasMap.put(aliased.getAlias(), r);
    }
}

