/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.deployment;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.metamodel.ManagedType;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.core.impl.deployment.DeploymentUnitTask;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.util.IncrementalNamingThreadFactory;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public abstract class DeploymentManager<X> {
    private final BLogger log;
    private final MetamodelImpl metamodel;
    private final List<ManagedType<?>> types = Lists.newArrayList();
    private final Collection<NamedQueryMetadata> namedQueries = Lists.newArrayList();
    private final Set<TypeImpl<?>> performed = Sets.newHashSet();
    private final ThreadPoolExecutor executer;
    private final Context context;

    public DeploymentManager(BLogger log, String name, MetamodelImpl metamodel, Context context) {
        this.log = log;
        this.metamodel = metamodel;
        this.context = context;
        switch (context) {
            case MANAGED_TYPES: {
                this.types.addAll(this.metamodel.getManagedTypes());
                break;
            }
            case IDENTIFIABLE_TYPES: {
                this.types.addAll(this.metamodel.getIdentifiables());
                break;
            }
            case ENTITIES: {
                this.types.addAll(this.metamodel.getEntities());
                break;
            }
            case NAMED_QUERIES: {
                this.namedQueries.addAll(this.metamodel.getNamedQueries());
            }
        }
        int nThreads = Runtime.getRuntime().availableProcessors() * 2;
        this.executer = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue(), new IncrementalNamingThreadFactory(name)){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return new DeploymentUnitFuture((DeploymentUnitTask)callable);
            }
        };
        this.log.debug("Number of threads is {0}", nThreads);
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    protected void handleException(Throwable t) throws BatooException {
        if (t instanceof BatooException) {
            throw (BatooException)t;
        }
        if (t.getCause() != null) {
            throw new BatooException("Unknown error occurred during deployment", t.getCause());
        }
        this.handleException(t.getCause());
    }

    public boolean hasPerformed(TypeImpl<?> type) {
        if (!this.types.contains(type)) {
            return true;
        }
        if (type == null) {
            return true;
        }
        return this.performed.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void perform() throws BatooException {
        long start = System.currentTimeMillis();
        ArrayList futures = Lists.newArrayList();
        if (this.context == Context.NAMED_QUERIES) {
            for (NamedQueryMetadata namedQueryMetadata : this.namedQueries) {
                futures.add(this.executer.submit(new DeploymentUnitTask(this, namedQueryMetadata)));
            }
        } else {
            for (ManagedType managedType : this.types) {
                futures.add(this.executer.submit(new DeploymentUnitTask(this, managedType)));
            }
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        finally {
            this.executer.shutdownNow();
        }
        this.log.debug("Deployment pass took {0} msecs", System.currentTimeMillis() - start);
    }

    public abstract Void perform(X var1) throws BatooException;

    public void performed(X type) {
        if (!(type instanceof NamedQueryMetadata)) {
            this.performed.add((TypeImpl)type);
        }
    }

    private class DeploymentUnitFuture
    extends FutureTask<Void>
    implements Comparable<DeploymentUnitFuture> {
        private final DeploymentUnitTask task;

        public DeploymentUnitFuture(DeploymentUnitTask task) {
            super(task);
            this.task = task;
        }

        @Override
        public int compareTo(DeploymentUnitFuture o) {
            return this.task.compareTo(o.task);
        }
    }

    protected static enum Context {
        MANAGED_TYPES,
        IDENTIFIABLE_TYPES,
        ENTITIES,
        NAMED_QUERIES;

    }
}

