/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.instance;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.EntityType;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class Enhancer {
    private static final Set<String> IGNORED_METHODS = Sets.newHashSet();
    public static final String SUFFIX_ENHANCED = "$Enhanced";
    private static final String THIS = "this";
    private static final String CLASS_ENHANCED_SUFFIX = "$Enhanced";
    private static final String CONSTRUCTOR_INIT = "<init>";
    private static final String FIELD_SERIAL_VERSION_UID = "serialVersionUID";
    private static final String FIELD_ENHANCED_INITIALIZED = "__enhanced_$$__initialized";
    private static final String FIELD_ENHANCED_SESSION = "__enhanced_$$__session";
    private static final String FIELD_ENHANCED_TYPE = "__enhanced_$$__type";
    private static final String FIELD_ENHANCED_ID = "__enhanced_$$__id";
    private static final String FIELD_ENHANCED_MANAGED_INSTANCE = "__enhanced_$$__managedInstance";
    private static final String METHOD_ENHANCED_IS_INITIALIZED = "__enhanced__$$__isInitialized";
    private static final String METHOD_ENHANCED_SET_INITIALIZED = "__enhanced__$$__setInitialized";
    private static final String METHOD_ENHANCED_CHECK = "__enhanced_$$__check";
    private static final String METHOD_GET_ENTITY_MANAGER = "getEntityManager";
    private static final String METHOD_ENHANCED_GET_MANAGED_INSTANCE = "__enhanced__$$__getManagedInstance";
    private static final String METHOD_ENHANCED_SET_MANAGED_INSTANCE = "__enhanced__$$__setManagedInstance";
    private static final String METHOD_FIND = "find";
    private static final String METHOD_CHANGED = "changed";
    private static final String DESCRIPTOR_BOOLEAN;
    private static final String DESCRIPTOR_MANAGED_INSTANCE;
    private static final String DESCRIPTOR_OBJECT;
    private static final String DESCRIPTOR_SESSION;
    private static final String DESCRIPTOR_CLASS;
    private static final String INTERNAL_PERSISTENCE_EXCEPTION;
    private static final String INTERNAL_SESSION;
    private static final String INTERNAL_ENTITY_MANAGER;
    private static final String INTERNAL_MANAGED_INSTANCE;

    public static byte[] create(Class<?> clazz) throws Exception {
        String enhancingClassName = Type.getInternalName(clazz);
        String enhancedClassName = enhancingClassName + "$Enhanced";
        String descEnhancer = Enhancer.makeClassDesc(enhancedClassName);
        ClassWriter cw = new ClassWriter(2);
        cw.visit(50, 33, enhancedClassName, null, enhancingClassName, new String[]{Type.getInternalName(EnhancedInstance.class)});
        cw.visitField(26, FIELD_SERIAL_VERSION_UID, Type.getDescriptor(Long.TYPE), null, (Object)new Long(1L)).visitEnd();
        cw.visitField(2, FIELD_ENHANCED_INITIALIZED, DESCRIPTOR_BOOLEAN, null, null).visitEnd();
        cw.visitField(146, FIELD_ENHANCED_ID, DESCRIPTOR_OBJECT, null, null).visitEnd();
        cw.visitField(146, FIELD_ENHANCED_TYPE, DESCRIPTOR_CLASS, null, null).visitEnd();
        cw.visitField(146, FIELD_ENHANCED_SESSION, DESCRIPTOR_SESSION, null, null).visitEnd();
        cw.visitField(130, FIELD_ENHANCED_MANAGED_INSTANCE, DESCRIPTOR_MANAGED_INSTANCE, null, null).visitEnd();
        Enhancer.createNoArgConstructor(enhancingClassName, enhancedClassName, descEnhancer, cw);
        Enhancer.createContainerConstructor(enhancingClassName, enhancedClassName, descEnhancer, cw);
        Enhancer.createMethodIsInitialized(enhancedClassName, descEnhancer, cw);
        Enhancer.createMethodSetInitialized(enhancedClassName, descEnhancer, cw);
        Enhancer.createMethodCheck(enhancedClassName, descEnhancer, cw);
        Enhancer.createMethodGetManagedInstance(enhancedClassName, descEnhancer, cw);
        Enhancer.createMethodSetManagedInstance(enhancedClassName, descEnhancer, cw);
        HashMap methods = Maps.newHashMap();
        for (Class<?> currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                String desc;
                int modifiers = method.getModifiers();
                modifiers &= 0x400;
                modifiers &= 0x10;
                modifiers &= 0x100;
                modifiers &= 2;
                modifiers &= 4;
                modifiers &= 8;
                if ((modifiers &= 0x800) != 1 && modifiers != 0 || methods.get(desc = method.getName() + Enhancer.makeDescription(Void.TYPE, method.getParameterTypes())) != null) continue;
                methods.put(desc, method);
            }
        }
        for (Method method : methods.values()) {
            if (IGNORED_METHODS.contains(method.getName())) continue;
            Enhancer.createOverrriddenMethod(enhancingClassName, enhancedClassName, descEnhancer, cw, method);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void createContainerConstructor(String enhancingClassName, String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, CONSTRUCTOR_INIT, Enhancer.makeDescription(Void.TYPE, Class.class, SessionImpl.class, Object.class, Boolean.TYPE), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, enhancingClassName, CONSTRUCTOR_INIT, Enhancer.makeDescription(Void.TYPE, new Class[0]));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_TYPE, DESCRIPTOR_CLASS);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_SESSION, DESCRIPTOR_SESSION);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_ID, DESCRIPTOR_OBJECT);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 4);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_INITIALIZED, DESCRIPTOR_BOOLEAN);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l1, 0);
        mv.visitLocalVariable("type", DESCRIPTOR_CLASS, null, l0, l1, 1);
        mv.visitLocalVariable("session", DESCRIPTOR_SESSION, null, l0, l1, 2);
        mv.visitLocalVariable("id", DESCRIPTOR_OBJECT, null, l0, l1, 3);
        mv.visitLocalVariable("initialized", DESCRIPTOR_BOOLEAN, null, l0, l1, 4);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createMethodCheck(String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(2, METHOD_ENHANCED_CHECK, Enhancer.makeDescription(Void.TYPE, new Class[0]), null, null);
        mv.visitCode();
        Label lCheckInitialized = new Label();
        Label lReturn = new Label();
        new Label();
        Label lFind = new Label();
        Label lInitialized = new Label();
        Label lChanged = new Label();
        Label lOut = new Label();
        mv.visitLabel(lCheckInitialized);
        mv.visitFrame(-1, 1, new Object[]{enhancedClassName}, 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_INITIALIZED, DESCRIPTOR_BOOLEAN);
        mv.visitJumpInsn(154, lChanged);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_SESSION, DESCRIPTOR_SESSION);
        mv.visitJumpInsn(199, lFind);
        mv.visitTypeInsn(187, INTERNAL_PERSISTENCE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"No session to initialize the instance");
        mv.visitMethodInsn(183, INTERNAL_PERSISTENCE_EXCEPTION, CONSTRUCTOR_INIT, Enhancer.makeDescription(Void.TYPE, String.class));
        mv.visitInsn(191);
        mv.visitLabel(lFind);
        mv.visitFrame(-1, 1, new Object[]{enhancedClassName}, 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_SESSION, DESCRIPTOR_SESSION);
        mv.visitMethodInsn(182, INTERNAL_SESSION, METHOD_GET_ENTITY_MANAGER, Enhancer.makeDescription(EntityManagerImpl.class, new Class[0]));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_TYPE, DESCRIPTOR_CLASS);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_ID, DESCRIPTOR_OBJECT);
        mv.visitMethodInsn(182, INTERNAL_ENTITY_MANAGER, METHOD_FIND, Enhancer.makeDescription(Object.class, Class.class, Object.class));
        mv.visitInsn(87);
        mv.visitLabel(lInitialized);
        mv.visitFrame(-1, 1, new Object[]{enhancedClassName}, 0, new Object[0]);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_INITIALIZED, DESCRIPTOR_BOOLEAN);
        mv.visitLabel(lChanged);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_SESSION, DESCRIPTOR_SESSION);
        mv.visitJumpInsn(198, lReturn);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_MANAGED_INSTANCE, DESCRIPTOR_MANAGED_INSTANCE);
        mv.visitMethodInsn(182, INTERNAL_MANAGED_INSTANCE, METHOD_CHANGED, Enhancer.makeDescription(Void.TYPE, new Class[0]));
        mv.visitLabel(lReturn);
        mv.visitFrame(-1, 1, new Object[]{enhancedClassName}, 0, new Object[0]);
        mv.visitInsn(177);
        mv.visitLabel(lOut);
        mv.visitLocalVariable(THIS, descEnhancer, null, lCheckInitialized, lOut, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createMethodGetManagedInstance(String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, METHOD_ENHANCED_GET_MANAGED_INSTANCE, Enhancer.makeDescription(ManagedInstance.class, new Class[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_MANAGED_INSTANCE, DESCRIPTOR_MANAGED_INSTANCE);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l1, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createMethodIsInitialized(String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, METHOD_ENHANCED_IS_INITIALIZED, Enhancer.makeDescription(Boolean.TYPE, new Class[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, enhancedClassName, FIELD_ENHANCED_INITIALIZED, DESCRIPTOR_BOOLEAN);
        mv.visitInsn(172);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l1, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createMethodSetInitialized(String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, METHOD_ENHANCED_SET_INITIALIZED, Enhancer.makeDescription(Void.TYPE, new Class[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_INITIALIZED, DESCRIPTOR_BOOLEAN);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l1, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createMethodSetManagedInstance(String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, METHOD_ENHANCED_SET_MANAGED_INSTANCE, Enhancer.makeDescription(Void.TYPE, ManagedInstance.class), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_MANAGED_INSTANCE, DESCRIPTOR_MANAGED_INSTANCE);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l1, 0);
        mv.visitLocalVariable("instance", DESCRIPTOR_MANAGED_INSTANCE, null, l0, l1, 1);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createNoArgConstructor(String enhancingClassName, String enhancedClassName, String descEnhancer, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, CONSTRUCTOR_INIT, Enhancer.makeDescription(Void.TYPE, new Class[0]), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, enhancingClassName, CONSTRUCTOR_INIT, Enhancer.makeDescription(Void.TYPE, new Class[0]));
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_ID, DESCRIPTOR_OBJECT);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_TYPE, DESCRIPTOR_CLASS);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, enhancedClassName, FIELD_ENHANCED_SESSION, DESCRIPTOR_SESSION);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l1, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createOverrriddenMethod(String enhancingClassName, String enhancedClassName, String descEnhancer, ClassWriter cw, Method method) {
        String methodDescription = Enhancer.makeDescription(method.getReturnType(), method.getParameterTypes());
        for (int i = 0; i < method.getExceptionTypes().length; ++i) {
        }
        MethodVisitor mv = cw.visitMethod(method.getModifiers(), method.getName(), methodDescription, null, null);
        mv.visitCode();
        Label lCheck = new Label();
        mv.visitLabel(lCheck);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, enhancedClassName, METHOD_ENHANCED_CHECK, Enhancer.makeDescription(Void.TYPE, new Class[0]));
        mv.visitVarInsn(25, 0);
        int i = 0;
        int r = 1;
        while (i < method.getParameterTypes().length) {
            Class<?> paramClass = method.getParameterTypes()[i];
            mv.visitVarInsn(Enhancer.getLoadType(paramClass), r);
            if (paramClass == Double.TYPE || paramClass == Long.TYPE) {
                ++r;
            }
            ++i;
            ++r;
        }
        mv.visitMethodInsn(183, enhancingClassName, method.getName(), methodDescription);
        if (method.getReturnType() != Void.TYPE) {
            mv.visitInsn(Enhancer.getReturnType(method.getReturnType()));
        } else {
            mv.visitInsn(177);
        }
        Label lOut = new Label();
        mv.visitLabel(lOut);
        Enhancer.registerLocals(descEnhancer, method, mv, lCheck, lOut);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static <T> Class<T> enhance(EntityType<T> type) throws Exception {
        String className;
        Class javaType = type.getJavaType();
        ClassLoader classLoader = javaType.getClassLoader();
        Class<?> enhancedClass = Enhancer.tryLoadClass(classLoader, className = type.getJavaType().getName() + "$Enhanced");
        if (enhancedClass != null) {
            return enhancedClass;
        }
        return Enhancer.enhance0(javaType, classLoader, className);
    }

    private static synchronized <T> Class<T> enhance0(Class<T> javaType, ClassLoader classLoader, String className) throws Exception {
        byte[] byteCode = Enhancer.create(javaType);
        Class<T> enhancedClass = Enhancer.loadClass(classLoader, byteCode, className);
        return enhancedClass;
    }

    private static void getDescriptor(StringBuffer buf, Class<?> c) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
    }

    private static int getLoadType(Class<?> paramClass) {
        if (!paramClass.isPrimitive() || paramClass.isArray()) {
            return 25;
        }
        if (Long.TYPE == paramClass) {
            return 22;
        }
        if (Float.TYPE == paramClass) {
            return 23;
        }
        if (Double.TYPE == paramClass) {
            return 24;
        }
        return 21;
    }

    private static int getReturnType(Class<?> paramClass) {
        if (!paramClass.isPrimitive() || paramClass.isArray()) {
            return 176;
        }
        if (Long.TYPE == paramClass) {
            return 173;
        }
        if (Float.TYPE == paramClass) {
            return 174;
        }
        if (Double.TYPE == paramClass) {
            return 175;
        }
        return 172;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<T> loadClass(ClassLoader classLoader, byte[] byteCode, String className) throws Exception {
        Class<?> cls = Class.forName("java.lang.ClassLoader");
        Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        try {
            Object[] args = new Object[]{className, byteCode, new Integer(0), new Integer(byteCode.length)};
            Class clazz = (Class)method.invoke((Object)classLoader, args);
            return clazz;
        }
        finally {
            method.setAccessible(false);
        }
    }

    private static String makeClassDesc(String className) {
        return "L" + className + ";";
    }

    private static String makeDescription(Class<?> returnType, Class<?> ... parameters) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            Enhancer.getDescriptor(buf, parameters[i]);
        }
        buf.append(')');
        Enhancer.getDescriptor(buf, returnType);
        return buf.toString();
    }

    private static void registerLocals(String descEnhancer, Method method, MethodVisitor mv, Label l0, Label l) {
        mv.visitLocalVariable(THIS, descEnhancer, null, l0, l, 0);
        int i = 0;
        int r = 1;
        while (i < method.getParameterTypes().length) {
            Class<?> paramClass = method.getParameterTypes()[i];
            mv.visitLocalVariable("arg" + i, Type.getDescriptor(paramClass), null, l0, l, r);
            if (paramClass == Double.TYPE || paramClass == Long.TYPE) {
                ++r;
            }
            ++i;
            ++r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> tryLoadClass(ClassLoader classLoader, String className) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    static {
        for (Method method : Object.class.getMethods()) {
            IGNORED_METHODS.add(method.getName());
        }
        DESCRIPTOR_BOOLEAN = Type.getDescriptor(Boolean.TYPE);
        DESCRIPTOR_MANAGED_INSTANCE = Type.getDescriptor(ManagedInstance.class);
        DESCRIPTOR_OBJECT = Type.getDescriptor(Object.class);
        DESCRIPTOR_SESSION = Type.getDescriptor(SessionImpl.class);
        DESCRIPTOR_CLASS = Type.getDescriptor(Class.class);
        INTERNAL_PERSISTENCE_EXCEPTION = Type.getInternalName(PersistenceException.class);
        INTERNAL_SESSION = Type.getInternalName(SessionImpl.class);
        INTERNAL_ENTITY_MANAGER = Type.getInternalName(EntityManagerImpl.class);
        INTERNAL_MANAGED_INSTANCE = Type.getInternalName(ManagedInstance.class);
    }
}

