/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.ElementColumn;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.JoinableTable;
import org.batoo.jpa.core.impl.jdbc.MapKeyColumn;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.model.mapping.ElementMapping;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.CollectionTableMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class CollectionTable
extends AbstractTable
implements JoinableTable {
    private final JdbcAdaptor jdbcAdaptor;
    private final EntityTypeImpl<?> entity;
    private final ForeignKey key;
    private OrderColumn orderColumn;
    private ElementColumn elementColumn;
    private String removeSql;
    private String removeAllSql;
    private AbstractColumn[] removeColumns;
    private JoinColumn[] removeAllColumns;
    private MapKeyColumn keyColumn;

    public CollectionTable(EntityTypeImpl<?> entity, CollectionTableMetadata metadata) {
        super(metadata);
        this.entity = entity;
        this.jdbcAdaptor = entity.getMetamodel().getJdbcAdaptor();
        this.key = new ForeignKey(entity.getMetamodel().getJdbcAdaptor(), metadata != null ? metadata.getJoinColumns() : Collections.emptyList());
    }

    public ForeignKey getKey() {
        return this.key;
    }

    public MapKeyColumn getKeyColumn() {
        return this.keyColumn;
    }

    public OrderColumn getOrderColumn() {
        return this.orderColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveAllSql() {
        if (this.removeAllSql != null) {
            return this.removeAllSql;
        }
        CollectionTable collectionTable = this;
        synchronized (collectionTable) {
            if (this.removeAllSql != null) {
                return this.removeAllSql;
            }
            ArrayList restrictions = Lists.newArrayList();
            this.removeAllColumns = new JoinColumn[this.key.getJoinColumns().size()];
            int i = 0;
            for (JoinColumn column : this.key.getJoinColumns()) {
                restrictions.add(column.getName() + " = ?");
                this.removeAllColumns[i++] = column;
            }
            this.removeAllSql = "DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions);
            return this.removeAllSql;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveSql() {
        if (this.removeSql != null) {
            return this.removeSql;
        }
        CollectionTable collectionTable = this;
        synchronized (collectionTable) {
            if (this.removeSql != null) {
                return this.removeSql;
            }
            ArrayList restrictions = Lists.newArrayList();
            this.removeColumns = new AbstractColumn[this.getColumns().size()];
            int i = 0;
            for (AbstractColumn column : this.getColumns()) {
                if (column == this.orderColumn) continue;
                restrictions.add(column.getName() + " = ?");
                this.removeColumns[i++] = column;
            }
            this.removeSql = "DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions);
            return this.removeSql;
        }
    }

    public void link(EmbeddableTypeImpl<?> type, String defaultName, ElementMapping<?> elementMapping) {
        if (StringUtils.isBlank((String)this.getName())) {
            this.setName(defaultName);
        }
        this.key.link(null, this.entity);
        this.key.setTable(this);
    }

    public void link(TypeImpl<?> type, String defaultName, ColumnMetadata metadata, EnumType enumType, TemporalType temporalType, boolean lob) {
        if (StringUtils.isBlank((String)this.getName())) {
            this.setName(this.entity.getName() + "_" + defaultName);
        }
        this.key.link(null, this.entity);
        this.key.setTable(this);
        this.elementColumn = new ElementColumn(this.entity.getMetamodel().getJdbcAdaptor(), this, metadata == null || StringUtils.isBlank((String)metadata.getName()) ? defaultName : metadata.getName(), type.getJavaType(), enumType, temporalType, lob, metadata);
    }

    @Override
    public void performInsert(ConnectionImpl connection, Object source, Object key, Object destination, int order) throws SQLException {
        String insertSql = this.getInsertSql(null);
        AbstractColumn[] insertColumns = this.getInsertColumns(null);
        Object[] params = new Object[insertColumns.length];
        for (int i = 0; i < insertColumns.length; ++i) {
            AbstractColumn column = insertColumns[i];
            params[i] = column == this.orderColumn ? Integer.valueOf(order) : (column == this.keyColumn ? key : (this.elementColumn == column ? this.elementColumn.getValue(destination) : (column instanceof JoinColumn ? column.getValue(source) : column.getValue(destination))));
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken()).update((Connection)connection, insertSql, params);
    }

    @Override
    public void performRemove(ConnectionImpl connection, Object source, Object key, Object destination) throws SQLException {
        String removeSql = this.getRemoveSql();
        Object[] params = new Object[this.removeColumns.length];
        int i = 0;
        for (AbstractColumn column : this.removeColumns) {
            params[i++] = column instanceof ElementColumn ? column.getValue(destination) : (column == this.keyColumn ? key : (column instanceof JoinColumn ? column.getValue(source) : column.getValue(destination)));
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken()).update((Connection)connection, removeSql, params);
    }

    @Override
    public void performRemoveAll(ConnectionImpl connection, Object source) throws SQLException {
        String removeAllSql = this.getRemoveAllSql();
        Object[] params = new Object[this.removeAllColumns.length];
        int i = 0;
        for (JoinColumn sourceRemoveColumn : this.removeAllColumns) {
            params[i++] = sourceRemoveColumn.getValue(source);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken()).update((Connection)connection, removeAllSql, params);
    }

    public void setKeyColumn(ColumnMetadata mapKeyColumn, String name, TemporalType mapKeyTemporalType, EnumType mapKeyEnumType, Class<?> mapKeyJavaType) {
        this.keyColumn = new MapKeyColumn(this, mapKeyColumn, name, mapKeyTemporalType, mapKeyEnumType, mapKeyJavaType);
    }

    public void setOrderColumn(ColumnMetadata orderColumn, String name) {
        this.orderColumn = new OrderColumn(this, orderColumn, name);
    }
}

