/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.jdbc.SecondaryTable;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;

public class ForeignKey {
    private final List<JoinColumn> joinColumns = Lists.newArrayList();
    private final boolean inverseOwner;
    private AbstractTable table;
    private String tableName;
    private OrderColumn orderColumn;
    private String singleChildSql;
    private AbstractColumn[] singleChildRestrictions;
    private String allChildrenSql;
    private AbstractColumn[] singleChildUpdates;
    private JoinColumn[] allChildrenRestrictions;
    private final JdbcAdaptor jdbcAdaptor;

    public ForeignKey(JdbcAdaptor jdbcAdaptor, List<JoinColumnMetadata> metadata) {
        this(jdbcAdaptor, metadata, false);
    }

    public ForeignKey(JdbcAdaptor jdbcAdaptor, List<JoinColumnMetadata> metadata, boolean inverseOwner) {
        this.jdbcAdaptor = jdbcAdaptor;
        this.inverseOwner = inverseOwner;
        for (JoinColumnMetadata columnMetadata : metadata) {
            this.joinColumns.add(new JoinColumn(jdbcAdaptor, columnMetadata));
        }
    }

    public ForeignKey(JdbcAdaptor jdbcAdaptor, SecondaryTable table, EntityTypeImpl<?> entity, List<PrimaryKeyJoinColumnMetadata> metadata) {
        this.jdbcAdaptor = jdbcAdaptor;
        this.inverseOwner = false;
        if (metadata == null || metadata.size() == 0) {
            if (entity.hasSingleIdAttribute()) {
                SingularMapping<?, ?> idMapping = entity.getIdMapping();
                if (idMapping instanceof BasicMapping) {
                    this.joinColumns.add(new JoinColumn(jdbcAdaptor, table, (BasicMapping)idMapping));
                } else {
                    this.createEmbeddedJoins(table, (EmbeddedMapping)idMapping, null);
                }
            } else {
                for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : entity.getIdMappings()) {
                    this.joinColumns.add(new JoinColumn(jdbcAdaptor, table, pair.getFirst()));
                }
            }
        } else if (entity.hasSingleIdAttribute()) {
            SingularMapping<?, ?> idMapping = entity.getIdMapping();
            if (idMapping instanceof BasicMapping) {
                BasicMapping basicMapping = (BasicMapping)idMapping;
                PrimaryKeyJoinColumnMetadata columnMetadata = this.getColumnMetadata(metadata, basicMapping);
                this.joinColumns.add(new JoinColumn(jdbcAdaptor, columnMetadata, table, basicMapping));
            } else {
                this.createEmbeddedJoins(table, (EmbeddedMapping)idMapping, metadata);
            }
        } else {
            for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : entity.getIdMappings()) {
                BasicMapping<?, ?> basicMapping = pair.getFirst();
                PrimaryKeyJoinColumnMetadata columnMetadata = this.getColumnMetadata(metadata, basicMapping);
                this.joinColumns.add(new JoinColumn(jdbcAdaptor, columnMetadata, table, basicMapping));
            }
        }
        this.table = table;
        this.table.addForeignKey(this);
    }

    public String createDestinationJoin(JoinType joinType, String parentAlias, String alias) {
        if (this.inverseOwner) {
            return this.createSourceJoin(joinType, parentAlias, alias);
        }
        return this.createJoin(joinType, parentAlias, alias, this.joinColumns.get(0).getReferencedTable().getName(), false);
    }

    private void createEmbeddedJoins(SecondaryTable table, EmbeddedMapping<?, ?> mapping, List<PrimaryKeyJoinColumnMetadata> metadata) {
        for (Mapping child : mapping.getChildren()) {
            if (child instanceof BasicMapping) {
                BasicMapping basicMapping = (BasicMapping)child;
                if (metadata != null && metadata.size() > 0) {
                    PrimaryKeyJoinColumnMetadata columnMetadata = this.getColumnMetadata(metadata, basicMapping);
                    this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, columnMetadata, table, basicMapping));
                    continue;
                }
                this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, table, basicMapping));
                continue;
            }
            this.createEmbeddedJoins(table, (EmbeddedMapping)child, metadata);
        }
    }

    private String createJoin(JoinType joinType, String parentAlias, String alias, String tableName, boolean source) {
        ArrayList parts = Lists.newArrayList();
        for (JoinColumn joinColumn : this.joinColumns) {
            String leftColumnName = source ? joinColumn.getReferencedColumnName() : joinColumn.getName();
            String rightColumnName = source ? joinColumn.getName() : joinColumn.getReferencedColumnName();
            String part = parentAlias + "." + leftColumnName + " = " + alias + "." + rightColumnName;
            parts.add(part);
        }
        String join = Joiner.on((String)" AND ").join((Iterable)parts);
        switch (joinType) {
            case INNER: {
                return "INNER JOIN " + tableName + " " + alias + " ON " + join;
            }
            case LEFT: {
                return "LEFT JOIN " + tableName + " " + alias + " ON " + join;
            }
        }
        return "RIGHT JOIN " + tableName + " " + alias + " ON " + join;
    }

    public String createSourceJoin(JoinType joinType, String parentAlias, String alias) {
        return this.createJoin(joinType, parentAlias, alias, this.joinColumns.get(0).getTable().getName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAllChildrenSql() {
        if (this.allChildrenSql != null) {
            return this.allChildrenSql;
        }
        ForeignKey foreignKey = this;
        synchronized (foreignKey) {
            if (this.allChildrenSql != null) {
                return this.allChildrenSql;
            }
            final ArrayList allChildrenRestrictions = Lists.newArrayList();
            String updates = Joiner.on((String)", ").join((Iterable)Lists.transform(this.joinColumns, (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    return input.getName() + " = NULL";
                }
            }));
            String restrictions = Joiner.on((String)", ").join((Iterable)Lists.transform(this.joinColumns, (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    allChildrenRestrictions.add(input);
                    return input.getName() + " = ?";
                }
            }));
            String order = this.orderColumn != null ? ", " + this.orderColumn.getName() + " = NULL" : "";
            this.allChildrenRestrictions = allChildrenRestrictions.toArray(new JoinColumn[allChildrenRestrictions.size()]);
            this.allChildrenSql = "UPDATE " + this.table.getQName() + "\nSET " + updates + order + "\nWHERE " + restrictions;
            return this.allChildrenSql;
        }
    }

    private PrimaryKeyJoinColumnMetadata getColumnMetadata(List<PrimaryKeyJoinColumnMetadata> metadata, BasicMapping<?, ?> basicMapping) {
        String columnName = basicMapping.getColumn().getMappingName();
        for (PrimaryKeyJoinColumnMetadata columnMetadata : metadata) {
            if (!columnName.equals(columnMetadata.getReferencedColumnName())) continue;
            return columnMetadata;
        }
        throw new MappingException("Primary key field cannot be found for " + basicMapping.getAttribute().getJavaMember() + ".", basicMapping.getAttribute().getLocator());
    }

    public List<JoinColumn> getJoinColumns() {
        return this.joinColumns;
    }

    public String getName() {
        ArrayList columns = Lists.newArrayList(this.joinColumns);
        Collections.sort(columns, new Comparator<JoinColumn>(){

            @Override
            public int compare(JoinColumn o1, JoinColumn o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int prime = 31;
        int id = 31 * ((JoinColumn)columns.get(0)).getReferencedTable().getQName().hashCode();
        id = 31 * ((JoinColumn)columns.get(0)).getTable().getQName().hashCode();
        for (JoinColumn joinColumn : columns) {
            id = 31 * id + joinColumn.getName().hashCode();
        }
        return "FK_" + Integer.toHexString(id).toUpperCase();
    }

    public OrderColumn getOrderColumn() {
        return this.orderColumn;
    }

    public String getReferencedTableName() {
        return this.joinColumns.get(0).getReferencedTable().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSingleChildSql() {
        if (this.singleChildSql != null) {
            return this.singleChildSql;
        }
        ForeignKey foreignKey = this;
        synchronized (foreignKey) {
            String order;
            if (this.singleChildSql != null) {
                return this.singleChildSql;
            }
            final ArrayList singleChildRestrictions = Lists.newArrayList();
            final ArrayList singleChildUpdates = Lists.newArrayList();
            String updates = Joiner.on((String)", ").join((Iterable)Lists.transform(this.joinColumns, (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    singleChildUpdates.add(input);
                    return input.getName() + " = ?";
                }
            }));
            if (this.orderColumn != null) {
                singleChildUpdates.add(this.orderColumn);
                order = ", " + this.orderColumn.getName() + " = ?";
            } else {
                order = "";
            }
            EntityTable table = (EntityTable)this.table;
            String restrictions = Joiner.on((String)" AND ").join((Iterable)Collections2.transform(table.getPkColumns(), (Function)new Function<AbstractColumn, String>(){

                public String apply(AbstractColumn input) {
                    singleChildRestrictions.add(input);
                    return input.getName() + " = ?";
                }
            }));
            this.singleChildRestrictions = singleChildRestrictions.toArray(new AbstractColumn[singleChildRestrictions.size()]);
            this.singleChildUpdates = singleChildUpdates.toArray(new AbstractColumn[singleChildUpdates.size()]);
            this.singleChildSql = "UPDATE " + this.table.getQName() + "\nSET " + updates + order + "\nWHERE " + restrictions;
            return this.singleChildSql;
        }
    }

    public AbstractTable getTable() {
        return this.table;
    }

    public void link(AssociationMapping<?, ?, ?> mapping, EntityTypeImpl<?> targetEntity) {
        if (targetEntity.hasSingleIdAttribute()) {
            SingularMapping<?, ?> idMapping = targetEntity.getIdMapping();
            if (idMapping instanceof BasicMapping) {
                this.linkJoinColumn(mapping, (BasicMapping)idMapping);
            } else {
                this.linkEmbeddedJoins(mapping, (EmbeddedMapping)idMapping);
            }
        } else {
            for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : targetEntity.getIdMappings()) {
                this.linkJoinColumn(mapping, pair.getFirst());
            }
        }
        if (mapping != null) {
            AbstractTable table = ((EntityTypeImpl)mapping.getRoot().getType()).getTable(this.tableName);
            if (table == null) {
                throw new MappingException("Table " + this.tableName + " could not be found", new AbstractLocator[0]);
            }
            this.setTable(table);
        }
    }

    private void linkEmbeddedJoins(AssociationMapping<?, ?, ?> mapping, EmbeddedMapping<?, ?> embeddedMapping) {
        for (Mapping child : embeddedMapping.getChildren()) {
            if (child instanceof BasicMapping) {
                this.linkJoinColumn(mapping, (BasicMapping)child);
                continue;
            }
            this.linkEmbeddedJoins(mapping, (EmbeddedMapping)child);
        }
    }

    private void linkJoinColumn(AssociationMapping<?, ?, ?> mapping, BasicMapping<?, ?> idMapping) {
        if (this.joinColumns.size() == 0) {
            this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, mapping, idMapping));
        } else {
            JoinColumn joinColumn = null;
            if (this.joinColumns.size() == 1 && StringUtils.isBlank((String)this.joinColumns.get(0).getReferencedColumnName())) {
                joinColumn = this.joinColumns.get(0);
            } else {
                for (JoinColumn column : this.joinColumns) {
                    if (!idMapping.getColumn().getName().equals(column.getReferencedColumnName())) continue;
                    joinColumn = column;
                    break;
                }
            }
            if (joinColumn == null) {
                throw new MappingException("Join column cannot be located in a composite key target entity", new AbstractLocator[0]);
            }
            joinColumn.setColumnProperties(mapping, idMapping);
        }
    }

    public void performAttachChild(ConnectionImpl connection, ManagedInstance<?> instance, Object key, Object child, int index) throws SQLException {
        String sql = this.getSingleChildSql();
        Object[] parameters = new Object[this.singleChildUpdates.length + this.singleChildRestrictions.length];
        int i = 0;
        for (AbstractColumn column : this.singleChildUpdates) {
            parameters[i++] = column instanceof JoinColumn ? column.getValue(instance.getInstance()) : Integer.valueOf(index);
        }
        for (AbstractColumn column : this.singleChildRestrictions) {
            parameters[i++] = column.getValue(child);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken()).update((Connection)connection, sql, parameters);
    }

    public void performDetachAll(ConnectionImpl connection, ManagedInstance<?> instance) throws SQLException {
        String sql = this.getAllChildrenSql();
        Object[] parameters = new Object[this.allChildrenRestrictions.length];
        int i = 0;
        for (JoinColumn column : this.allChildrenRestrictions) {
            parameters[i++] = ((AbstractColumn)column).getValue(instance.getInstance());
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken()).update((Connection)connection, sql, parameters);
    }

    public void performDetachChild(ConnectionImpl connection, Object key, Object child) throws SQLException {
        String sql = this.getSingleChildSql();
        Object[] parameters = new Object[this.singleChildUpdates.length + this.singleChildRestrictions.length];
        int i = 0;
        for (AbstractColumn column : this.singleChildUpdates) {
            parameters[i++] = column instanceof JoinColumn ? null : Integer.valueOf(0);
        }
        for (AbstractColumn column : this.singleChildRestrictions) {
            parameters[i++] = column.getValue(child);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken()).update((Connection)connection, sql, parameters);
    }

    public void setOrderColumn(ColumnMetadata orderColumn, String name) {
        this.orderColumn = new OrderColumn(this.table, orderColumn, name);
    }

    public void setTable(AbstractTable table) {
        this.table = table;
        for (JoinColumn joinColumn : this.joinColumns) {
            joinColumn.setTable(table);
        }
        this.table.addForeignKey(this);
    }

    public String toString() {
        return "ForeignKey [tableName=" + this.table.getName() + ", joinColumns=" + this.joinColumns + "]";
    }
}

