/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.TypeFactory;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class MapKeyColumn
extends AbstractColumn {
    private final String columnDefinition;
    private final AbstractLocator locator;
    private final String name;
    private final AbstractTable table;
    private final boolean insertable;
    private final boolean nullable;
    private final boolean updatable;
    private final int sqlType;
    private final int precision;
    private final int scale;
    private final int length;

    public MapKeyColumn(AbstractTable table, ColumnMetadata metadata, String name, TemporalType temporalType, EnumType enumType, Class<?> javaType) {
        this.sqlType = TypeFactory.getSqlType(javaType, temporalType, enumType, false);
        this.table = table;
        this.name = name;
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : null;
        this.insertable = metadata != null ? metadata.isInsertable() : true;
        this.nullable = metadata != null ? metadata.isNullable() : true;
        this.updatable = metadata != null ? metadata.isUpdatable() : true;
        this.length = metadata != null ? metadata.getLength() : 255;
        this.scale = metadata != null ? metadata.getScale() : 0;
        this.precision = metadata != null ? metadata.getPrecision() : 0;
        this.table.addColumn(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return null;
    }

    @Override
    public String getMappingName() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public Object getValue(Object instance) {
        return null;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public void setTable(AbstractTable table) {
    }

    @Override
    public void setValue(Object instance, Object value) {
    }
}

