/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.NotImplementedException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.manager.OperationTookLongTimeWarning;
import org.batoo.jpa.core.pool.GenericKeyedPool;

public class PreparedStatementImpl
implements PreparedStatement {
    private static final BLogger LOG = BLoggerFactory.getLogger(PreparedStatementImpl.class);
    private static AtomicLong no = new AtomicLong(0L);
    private final ConnectionImpl connection;
    private final String sql;
    private final PreparedStatement statement;
    private final long statementNo;
    private final long opened;
    private volatile long executeNo;
    private volatile long executes;
    private volatile long selects;
    private Object[] parameters;
    private final GenericKeyedPool<String, PreparedStatementImpl> pool;
    private ParameterMetaData parameterMetaData;
    private boolean debug;

    public PreparedStatementImpl(ConnectionImpl connection, String sql, PreparedStatement statement, GenericKeyedPool<String, PreparedStatementImpl> pool) {
        this.connection = connection;
        this.sql = sql;
        this.statement = statement;
        this.pool = pool;
        this.statementNo = no.incrementAndGet();
        this.opened = System.currentTimeMillis();
    }

    @Override
    public void addBatch() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void cancel() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void close() throws SQLException {
        if (this.pool == null) {
            this.close0();
        } else {
            try {
                this.pool.returnObject(this.sql, this);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close0() throws SQLException {
        long executeNo = ++this.executeNo;
        LOG.trace("{0}:{1}:{2} close()", this.connection.connNo, this.statementNo, executeNo);
        long start = System.currentTimeMillis();
        try {
            this.statement.close();
            LOG.trace("{0}:{1}, used for {2} msecs, executes= {3}, selects= {4}", this.connection.connNo, this.statementNo, System.currentTimeMillis() - this.opened, this.executes, this.selects);
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.trace(new OperationTookLongTimeWarning(), "{0}:{1}:{2} {3} msecs, close()", this.connection.connNo, this.statementNo, executeNo, time);
            } else {
                LOG.trace("{0}:{1}:{2} {3} msecs, close()", this.connection.connNo, this.statementNo, executeNo, time);
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.trace(new OperationTookLongTimeWarning(), "{0}:{1}:{2} {3} msecs, close()", this.connection.connNo, this.statementNo, executeNo, time);
        } else {
            LOG.trace("{0}:{1}:{2} {3} msecs, close()", this.connection.connNo, this.statementNo, executeNo, time);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public boolean execute() throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet;
        if (!this.debug) {
            return this.statement.executeQuery();
        }
        long executeNo = ++this.executeNo;
        ++this.executes;
        ++this.selects;
        LOG.debug("{0}:{1}:{2} executeQuery(){3}", this.connection.connNo, this.statementNo, executeNo, LOG.lazyBoxed(this.sql, this.parameters));
        long start = System.currentTimeMillis();
        try {
            ++this.connection.executes;
            resultSet = this.statement.executeQuery();
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1}:{2} {3} msecs, executeQuery()", this.connection.connNo, this.statementNo, executeNo, time);
            } else {
                LOG.trace("{0}:{1}:{2} {3} msecs, executeQuery()", this.connection.connNo, this.statementNo, executeNo, time);
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1}:{2} {3} msecs, executeQuery()", this.connection.connNo, this.statementNo, executeNo, time);
        } else {
            LOG.trace("{0}:{1}:{2} {3} msecs, executeQuery()", this.connection.connNo, this.statementNo, executeNo, time);
        }
        return resultSet;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int n;
        if (!this.debug) {
            return this.statement.executeUpdate();
        }
        long executeNo = ++this.executeNo;
        ++this.executes;
        LOG.debug("{0}:{1}:{2} executeUpdate(){3}", this.connection.connNo, this.statementNo, executeNo, LOG.lazyBoxed(this.sql, this.parameters));
        long start = System.currentTimeMillis();
        try {
            ++this.connection.executes;
            n = this.statement.executeUpdate();
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1}:{2} {3} msecs, executeUpdate()", this.connection.connNo, this.statementNo, executeNo, time);
            } else {
                LOG.debug("{0}:{1}:{2} {3} msecs, executeUpdate()", this.connection.connNo, this.statementNo, executeNo, time);
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1}:{2} {3} msecs, executeUpdate()", this.connection.connNo, this.statementNo, executeNo, time);
        } else {
            LOG.debug("{0}:{1}:{2} {3} msecs, executeUpdate()", this.connection.connNo, this.statementNo, executeNo, time);
        }
        return n;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.parameterMetaData != null) {
            return this.parameterMetaData;
        }
        this.parameterMetaData = this.statement.getParameterMetaData();
        if (this.parameters == null) {
            this.parameters = new Object[this.parameterMetaData.getParameterCount()];
        }
        return this.parameterMetaData;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    public PreparedStatement reset() {
        this.debug = LOG.isDebugEnabled();
        return this;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.debug && this.parameters != null) {
            this.parameters[parameterIndex - 1] = null;
        }
        this.statement.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.debug && this.parameters != null) {
            this.parameters[parameterIndex - 1] = x;
        }
        this.statement.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.throwNotImplemented();
    }

    private void throwNotImplemented() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.throwNotImplemented();
        return null;
    }
}

