/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.batoo.jpa.common.reflect.ConstructorAccessor;
import org.batoo.jpa.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.ManagedTypeImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.type.EmbeddableMetadata;

public class EmbeddableTypeImpl<X>
extends ManagedTypeImpl<X>
implements EmbeddableType<X> {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private ConstructorAccessor constructor;
    private Integer attributeCount;
    private SingularAttributeImpl<?, ?>[] singularMappings;

    public EmbeddableTypeImpl(MetamodelImpl metamodel, Class<X> javaType, EmbeddableMetadata metadata) {
        super(metamodel, javaType, metadata);
        this.addAttributes(metadata);
        try {
            this.constructor = ReflectHelper.createConstructor(javaType.getConstructor(new Class[0]));
        }
        catch (Exception e) {
            throw new MappingException("Embeddable type does not have a default constructor", this.getLocator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributeCount() {
        if (this.attributeCount != null) {
            return this.attributeCount;
        }
        EmbeddableTypeImpl embeddableTypeImpl = this;
        synchronized (embeddableTypeImpl) {
            if (this.attributeCount != null) {
                return this.attributeCount;
            }
            int attributeCount = 0;
            for (SingularAttribute attribute : this.getSingularAttributes()) {
                switch (attribute.getPersistentAttributeType()) {
                    case BASIC: {
                        ++attributeCount;
                        break;
                    }
                    case EMBEDDED: {
                        attributeCount += ((EmbeddableTypeImpl)attribute).getAttributeCount();
                    }
                    case MANY_TO_ONE: 
                    case ONE_TO_ONE: {
                        attributeCount += ((EntityTypeImpl)attribute.getType()).getPrimaryTable().getPkColumns().size();
                    }
                }
            }
            this.attributeCount = attributeCount;
            return this.attributeCount;
        }
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingularAttributeImpl<?, ?>[] getSingularMappings() {
        if (this.singularMappings != null) {
            return this.singularMappings;
        }
        EmbeddableTypeImpl embeddableTypeImpl = this;
        synchronized (embeddableTypeImpl) {
            if (this.singularMappings != null) {
                return this.singularMappings;
            }
            ArrayList singularMappings = Lists.newArrayList();
            for (SingularAttribute attribute : this.getSingularAttributes()) {
                switch (attribute.getPersistentAttributeType()) {
                    case BASIC: 
                    case EMBEDDED: {
                        singularMappings.add((SingularAttributeImpl)attribute);
                        break;
                    }
                    case MANY_TO_ONE: 
                    case ONE_TO_ONE: {
                        AssociatedSingularAttribute association = (AssociatedSingularAttribute)attribute;
                        if (!association.isOwner() || !association.isJoined()) break;
                        singularMappings.add((SingularAttributeImpl)attribute);
                    }
                }
            }
            Collections.sort(singularMappings, new Comparator<SingularAttributeImpl<? super X, ?>>(){

                @Override
                public int compare(SingularAttributeImpl<? super X, ?> o1, SingularAttributeImpl<? super X, ?> o2) {
                    return o1.getAttributeId().compareTo(o2.getAttributeId());
                }
            });
            this.singularMappings = singularMappings.toArray(new SingularAttributeImpl[singularMappings.size()]);
            return this.singularMappings;
        }
    }

    public X newInstance() {
        try {
            return (X)this.constructor.newInstance(EMPTY_PARAMS);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

