/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.jdbc.adapter;

import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcColumn {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String DATA_TYPE = "DATA_TYPE";
    private final String name;
    private final int size;
    private final int decimalDigits;
    private final boolean nullable;
    private final int type;

    public JdbcColumn(ResultSet metadata) throws SQLException {
        this.name = metadata.getString(COLUMN_NAME);
        this.size = metadata.getInt(COLUMN_SIZE);
        this.decimalDigits = metadata.getInt(DECIMAL_DIGITS);
        this.type = metadata.getInt(DATA_TYPE);
        this.nullable = !metadata.getString(IS_NULLABLE).equals("NO");
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

