/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.JavaLocator;
import org.batoo.jpa.parser.metadata.CallbackMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.type.IdentifiableTypeMetadata;

public class EntityListenerMetadataImpl
implements EntityListenerMetadata {
    private final AbstractLocator locator;
    private final boolean self;
    private final String className;
    private final List<CallbackMetadata> callbacks = Lists.newArrayList();

    public EntityListenerMetadataImpl(AbstractLocator locator, Class<?> clazz) {
        this.locator = locator;
        this.className = clazz.getName();
        this.self = false;
        this.handleCallbacks(clazz, null);
    }

    public EntityListenerMetadataImpl(AbstractLocator locator, Class<?> clazz, Set<Class<? extends Annotation>> annotationsParsed) {
        this.locator = locator;
        this.className = clazz.getName();
        this.handleCallbacks(clazz, annotationsParsed);
        this.self = true;
    }

    public EntityListenerMetadataImpl(AbstractLocator locator, EntityListenerMetadata metadata) {
        this.locator = locator;
        this.className = metadata.getClassName();
        this.callbacks.addAll(metadata.getCallbacks());
        this.self = false;
    }

    public EntityListenerMetadataImpl(AbstractLocator locator, IdentifiableTypeMetadata metadata, String className) {
        this.locator = locator;
        this.className = className;
        this.callbacks.addAll(metadata.getCallbacks());
        this.self = true;
    }

    private CallbackMetadata createCallback(final Method method, final EntityListenerMetadata.EntityListenerType type) {
        return new CallbackMetadata(){

            @Override
            public AbstractLocator getLocator() {
                return new JavaLocator(method);
            }

            @Override
            public String getName() {
                return method.getName();
            }

            @Override
            public EntityListenerMetadata.EntityListenerType getType() {
                return type;
            }
        };
    }

    @Override
    public List<CallbackMetadata> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    private void handleCallbacks(Class<?> clazz, Set<Class<? extends Annotation>> annotationsParsed) {
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() != clazz) continue;
            if (method.getAnnotation(PrePersist.class) != null) {
                if (annotationsParsed != null) {
                    annotationsParsed.add(PrePersist.class);
                }
                this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.PRE_PERSIST));
            }
            if (method.getAnnotation(PreUpdate.class) != null) {
                if (annotationsParsed != null) {
                    annotationsParsed.add(PreUpdate.class);
                }
                this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.PRE_UPDATE));
            }
            if (method.getAnnotation(PreRemove.class) != null) {
                if (annotationsParsed != null) {
                    annotationsParsed.add(PreRemove.class);
                }
                this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.PRE_REMOVE));
            }
            if (method.getAnnotation(PostLoad.class) != null) {
                if (annotationsParsed != null) {
                    annotationsParsed.add(PostLoad.class);
                }
                this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.POST_LOAD));
            }
            if (method.getAnnotation(PostPersist.class) != null) {
                if (annotationsParsed != null) {
                    annotationsParsed.add(PostPersist.class);
                }
                this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.POST_PERSIST));
            }
            if (method.getAnnotation(PostRemove.class) != null) {
                if (annotationsParsed != null) {
                    annotationsParsed.add(PostRemove.class);
                }
                this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.POST_REMOVE));
            }
            if (method.getAnnotation(PostUpdate.class) == null) continue;
            if (annotationsParsed != null) {
                annotationsParsed.add(PostUpdate.class);
            }
            this.callbacks.add(this.createCallback(method, EntityListenerMetadata.EntityListenerType.POST_UPDATE));
        }
    }

    public boolean self() {
        return this.self;
    }
}

