/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import org.batoo.jpa.parser.impl.orm.AccessElement;
import org.batoo.jpa.parser.impl.orm.CascadesElement;
import org.batoo.jpa.parser.impl.orm.CatalogElement;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.EntityListenersElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.SchemaElement;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;

public class PersistenceUnitDefaults
extends ParentElement {
    private final List<EntityListenerMetadata> listeners = Lists.newArrayList();
    private String catalog;
    private String schema;
    private boolean cascadePersist = false;
    private AccessType accessType = AccessType.FIELD;

    public PersistenceUnitDefaults(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "access", "catalog", "schema", "cascade-persist", "cascade-persist", "entity-listeners");
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public List<EntityListenerMetadata> getListeners() {
        return this.listeners;
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof AccessElement) {
            this.accessType = ((AccessElement)child).getAccessType();
        }
        if (child instanceof CatalogElement) {
            this.catalog = ((CatalogElement)child).getCatalog();
        }
        if (child instanceof SchemaElement) {
            this.schema = ((SchemaElement)child).getSchema();
        }
        if (child instanceof CascadesElement.CascadePersistElement) {
            this.cascadePersist = true;
        }
        if (child instanceof EntityListenersElement) {
            this.listeners.addAll(((EntityListenersElement)child).getListeners());
        }
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }
}

