/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.UniqueConstraintsElement;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public class TableElement
extends ParentElement
implements TableMetadata {
    private String catalog;
    private String schema;
    private String name;
    private final List<UniqueConstraintMetadata> uniqueConstraints = Lists.newArrayList();

    public TableElement(ParentElement parent, Map<String, String> attributes, String ... expectedChildElements) {
        super(parent, attributes, "unique-constraint");
    }

    @Override
    protected void generate() {
        this.catalog = this.getAttribute("catalog", "");
        this.schema = this.getAttribute("schema", "");
        this.name = this.getAttribute("name", "");
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof UniqueConstraintsElement) {
            this.uniqueConstraints.add((UniqueConstraintMetadata)((Object)child));
        }
    }
}

