/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm.attribute;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.batoo.jpa.parser.impl.orm.CascadesElement;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.JoinColumnElement;
import org.batoo.jpa.parser.impl.orm.JoinTableElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.PrimaryKeyJoinColumnElement;
import org.batoo.jpa.parser.impl.orm.attribute.AttributeElement;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinTableMetadata;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;

public class AssociationElement
extends AttributeElement
implements AssociationAttributeMetadata {
    private String targetEntity;
    private FetchType fetchType;
    private Set<CascadeType> cascades;
    private final List<JoinColumnMetadata> joinColumns = Lists.newArrayList();
    private JoinTableMetadata joinTable;
    private final List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns = Lists.newArrayList();

    public AssociationElement(ParentElement parent, Map<String, String> attributes, FetchType defaultFetchType, String ... expectedChildElements) {
        super(parent, attributes, "cascade", "join-column", "join-table", "primary-key-join-column");
        this.fetchType = defaultFetchType;
    }

    @Override
    protected void generate() {
        super.generate();
        this.targetEntity = this.getAttribute("target-entity", "");
        this.fetchType = FetchType.valueOf((String)this.getAttribute("fetch", this.fetchType.name()));
    }

    @Override
    public Set<CascadeType> getCascades() {
        return this.cascades;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public List<JoinColumnMetadata> getJoinColumns() {
        return this.joinColumns;
    }

    @Override
    public JoinTableMetadata getJoinTable() {
        return this.joinTable;
    }

    @Override
    public String getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof CascadesElement) {
            this.cascades = ((CascadesElement)child).getCascades();
        }
        if (child instanceof JoinColumnElement) {
            this.joinColumns.add((JoinColumnMetadata)((Object)child));
        }
        if (child instanceof JoinTableElement) {
            this.joinTable = (JoinTableMetadata)((Object)child);
        }
        if (child instanceof PrimaryKeyJoinColumnElement) {
            this.primaryKeyJoinColumns.add((PrimaryKeyJoinColumnMetadata)((Object)child));
        }
    }
}

