/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.common.reflect;

import java.lang.reflect.Method;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.reflect.AbstractAccessor;

public class MethodAccessor
extends AbstractAccessor {
    private final Method getter;
    private final Method setter;

    public MethodAccessor(Method getter, Method setter) {
        this.getter = getter;
        this.setter = setter;
        this.getter.setAccessible(true);
        this.setter.setAccessible(true);
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new BatooException("Getter invocation failed");
        }
    }

    @Override
    public void set(Object instance, Object value) {
        try {
            this.setter.invoke(instance, value);
        }
        catch (Exception e) {
            throw new BatooException("Setter invocation failed");
        }
    }
}

