/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.util.BatooUtils;

public abstract class ManagedCollection<E> {
    private final transient PluralMapping<?, ?, E> mapping;
    private final transient ManagedInstance<?> managedInstance;
    private boolean changed;
    private AssociationMapping<?, ?, ?> inverse;

    public ManagedCollection(PluralMapping<?, ?, E> mapping, ManagedInstance<?> managedInstance) {
        this.mapping = mapping;
        this.managedInstance = managedInstance;
        if (mapping instanceof PluralAssociationMapping) {
            this.inverse = ((PluralAssociationMapping)mapping).getInverse();
        }
    }

    public abstract boolean addChild(EntryImpl<Object, ManagedInstance<?>> var1);

    public abstract boolean addElement(EntryImpl<Object, ?> var1);

    protected final void changed() {
        if (!this.changed && this.managedInstance != null) {
            this.changed = true;
            this.managedInstance.setChanged(this.mapping);
        }
    }

    public abstract void flush(ConnectionImpl var1, boolean var2, boolean var3) throws SQLException;

    public abstract Collection<E> getDelegate();

    public ManagedInstance<?> getManagedInstance() {
        return this.managedInstance;
    }

    protected PluralMapping<?, ?, E> getMapping() {
        return this.mapping;
    }

    protected abstract Collection<E> getSnapshot();

    public abstract boolean isInitialized();

    public void mergeWith(EntityManagerImpl entityManager, Object instance, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed) {
        ArrayList mergedChildren = Lists.newArrayList();
        Object children = this.mapping.get(instance);
        Collection collection = children instanceof Collection ? (Collection)children : ((Map)children).values();
        for (Object child : collection) {
            mergedChildren.add(entityManager.mergeImpl(child, requiresFlush, processed, this.mapping.cascadesMerge()));
        }
        this.snapshot();
        Collection<E> delegate = this.getDelegate();
        boolean changed = false;
        SessionImpl session = entityManager.getSession();
        for (Object child : mergedChildren) {
            if (delegate.contains(child)) continue;
            this.getDelegate().add(child);
            if (this.inverse != null) {
                this.inverse.set(session.get(child).getInstance(), this.managedInstance.getInstance());
            }
            changed = true;
        }
        for (Object child : Lists.newArrayList(delegate)) {
            if (mergedChildren.contains(child)) continue;
            this.removeChild(child);
            if (this.inverse != null) {
                this.inverse.set(session.get(child).getInstance(), null);
            }
            changed = true;
        }
        if (changed) {
            this.changed();
        }
    }

    public void persistAdditions(EntityManagerImpl entityManager) {
        Collection<E> added = BatooUtils.subtract(this.getDelegate(), this.getSnapshot());
        for (E e : added) {
            entityManager.persistImpl(e, Lists.newArrayList());
        }
    }

    public abstract void refreshChildren();

    protected abstract void removeChild(E var1);

    protected boolean removed(ConnectionImpl connection, boolean removals) throws SQLException {
        if (removals && this.managedInstance.getStatus() == Status.REMOVED) {
            this.mapping.detachAll(connection, this.managedInstance);
            return true;
        }
        return false;
    }

    public void removeOrphans(EntityManagerImpl entityManager) {
        Collection<E> removed = BatooUtils.subtract(this.getSnapshot(), this.getDelegate());
        for (E e : removed) {
            entityManager.remove(e);
        }
    }

    protected void reset() {
        this.changed = false;
    }

    protected abstract void snapshot();
}

