/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.util.BatooUtils;

public class ManagedMap<X, K, V>
extends ManagedCollection<V>
implements Map<K, V> {
    private final HashMap<K, V> delegate = Maps.newHashMap();
    private HashMap<K, V> snapshot;
    private boolean initialized;

    public ManagedMap(PluralMapping<?, ?, V> mapping, ManagedInstance<?> managedInstance, boolean lazy) {
        super(mapping, managedInstance);
        this.initialized = !lazy;
    }

    public ManagedMap(PluralMapping<?, ?, V> mapping, ManagedInstance<?> managedInstance, Map<? extends K, ? extends V> values) {
        this(mapping, managedInstance, false);
        this.delegate.putAll(values);
        this.initialized = true;
    }

    @Override
    public boolean addChild(EntryImpl<Object, ManagedInstance<?>> child) {
        Object k = child.getKey();
        Object v = child.getValue().getInstance();
        if (!this.delegate.keySet().contains(k) && !this.delegate.values().contains(v)) {
            this.delegate.put(k, v);
            return true;
        }
        return false;
    }

    @Override
    public boolean addElement(EntryImpl<Object, ?> child) {
        Object k = child.getKey();
        Object v = child.getValue();
        if (!this.delegate.keySet().contains(k) && !this.delegate.values().contains(v)) {
            this.delegate.put(k, v);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.snapshot();
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.initialize();
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.initialize();
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.initialize();
        return this.delegate.entrySet();
    }

    @Override
    public void flush(ConnectionImpl connection, boolean removals, boolean force) throws SQLException {
        if (this.removed(connection, removals)) {
            return;
        }
        ManagedInstance<?> managedInstance = this.getManagedInstance();
        PluralMapping mapping = this.getMapping();
        if (force) {
            for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
                mapping.attach(connection, managedInstance, entry.getKey(), entry.getValue(), -1);
            }
            return;
        }
        if (this.snapshot == null) {
            return;
        }
        if (removals) {
            Collection<K> childrenRemoved = BatooUtils.subtract(this.snapshot.keySet(), this.delegate.keySet());
            for (K key : childrenRemoved) {
                mapping.detach(connection, managedInstance, key, this.snapshot.get(key));
            }
        } else {
            Collection<K> childrenAdded = BatooUtils.subtract(this.delegate.keySet(), this.snapshot.keySet());
            for (K key : childrenAdded) {
                mapping.attach(connection, managedInstance, key, this.delegate.get(key), -1);
            }
        }
    }

    @Override
    public V get(Object key) {
        this.initialize();
        return this.delegate.get(key);
    }

    @Override
    public Collection<V> getDelegate() {
        return this.delegate.values();
    }

    @Override
    protected Collection<V> getSnapshot() {
        return this.snapshot != null ? this.snapshot.values() : null;
    }

    private void initialize() {
        if (!this.initialized) {
            if (this.getManagedInstance() == null) {
                throw new PersistenceException("No session to initialize the collection");
            }
            this.delegate.putAll(this.getMapping().loadMap(this.getManagedInstance()));
            this.initialized = true;
        }
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Set<K> keySet() {
        this.initialize();
        return this.delegate.keySet();
    }

    private UnsupportedOperationException noDuplicates() {
        return new UnsupportedOperationException("Duplicates are not supported");
    }

    @Override
    public V put(K key, V value) {
        this.snapshot();
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (this.delegate.values().contains(value)) {
            throw this.noDuplicates();
        }
        if (this.delegate.values().contains(key)) {
            throw this.noDuplicates();
        }
        V v = this.delegate.put(key, value);
        this.changed();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.snapshot();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void refreshChildren() {
        super.reset();
        this.snapshot = null;
        this.delegate.clear();
        this.delegate.putAll(this.getMapping().loadMap(this.getManagedInstance()));
    }

    @Override
    public V remove(Object key) {
        this.snapshot();
        if (this.delegate.containsKey(key)) {
            this.changed();
        }
        return this.delegate.remove(key);
    }

    @Override
    protected void removeChild(V child) {
        for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
            if (!entry.getValue().equals(child)) continue;
            this.delegate.remove(entry.getKey());
            break;
        }
    }

    @Override
    public int size() {
        this.initialize();
        return this.delegate.size();
    }

    @Override
    protected void snapshot() {
        this.initialize();
        if (this.snapshot == null) {
            this.snapshot = Maps.newHashMap(this.delegate);
            this.reset();
        }
    }

    public String toString() {
        Object id = this.getManagedInstance().getId() != null ? this.getManagedInstance().getId().getId() : null;
        String instance = this.getManagedInstance().getType().getName() + "@" + id;
        return "ManagedMap [initialized=" + this.initialized + ", managedInstance=" + instance + ", delegate=" + this.delegate + ", snapshot=" + this.snapshot + ", mapping=" + this.getMapping() + "]";
    }

    @Override
    public Collection<V> values() {
        this.initialize();
        return this.delegate.values();
    }
}

