/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.cache.CacheImpl;
import org.batoo.jpa.core.impl.cache.CacheReference;
import org.batoo.jpa.core.impl.criteria.BaseQuery;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.EntityTransactionImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;

public class QueryImpl<X>
implements TypedQuery<X>,
ResultSetHandler<List<X>>,
Query {
    private static final int MAX_COL_LENGTH = 30;
    private static final BLogger LOG = BLoggerFactory.getLogger(QueryImpl.class);
    private final EntityManagerFactoryImpl emf;
    private final EntityManagerImpl em;
    private final BaseQuery<X> q;
    private String sql;
    private final Map<String, Object> hints = Maps.newHashMap();
    private int startPosition = 0;
    private int maxResult = Integer.MAX_VALUE;
    private final Map<ParameterExpressionImpl<?>, Object> parameters = Maps.newHashMap();
    private List<X> results;
    private LockModeType lockMode;
    private final List<Map<String, Object>> data = Lists.newArrayList();
    private ResultSetMetaData md;
    private String[] labels;
    private FlushModeType flushMode = FlushModeType.AUTO;

    public QueryImpl(BaseQuery<X> q, EntityManagerImpl entityManager) {
        this.emf = entityManager.getEntityManagerFactory();
        this.em = entityManager;
        this.q = q;
        this.sql = this.q.getSql();
        for (ParameterExpression<?> p : this.q.getParameters()) {
            this.parameters.put((ParameterExpressionImpl)p, null);
        }
    }

    private Object[] applyParameters() {
        if (this.startPosition != 0 || this.maxResult != Integer.MAX_VALUE) {
            LOG.debug("Rows restricted to {0} / {1}", this.startPosition, this.maxResult);
            this.sql = this.q.getMetamodel().getJdbcAdaptor().applyPagination(this.sql, this.startPosition, this.maxResult);
        }
        MetamodelImpl metamodel = this.em.getMetamodel();
        List<ParameterExpressionImpl<?>> sqlParameters = this.q.getSqlParameters();
        int paramCount = 0;
        for (ParameterExpressionImpl<?> parameter : sqlParameters) {
            paramCount += parameter.getExpandedCount(metamodel);
        }
        if (this.maxResult != Integer.MAX_VALUE || this.startPosition != 0) {
            JdbcAdaptor.PaginationParamsOrder paginationParamsOrder = this.q.getJdbcAdaptor().getPaginationParamsOrder();
            boolean paginationHasStart = this.startPosition != 0 || this.q.getJdbcAdaptor().paginationNeedsStartAlways();
            boolean paginationHasMaxResults = this.maxResult != Integer.MAX_VALUE || this.q.getJdbcAdaptor().paginationNeedsMaxResultsAlways();
            int n = paginationHasMaxResults && paginationHasStart ? 2 : 1;
            MutableInt sqlIndex = new MutableInt(0);
            Object[] parameters = new Object[paramCount += n];
            if (!paginationParamsOrder.isAfterMainSql()) {
                if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.MAX_START_SQL) {
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                } else {
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                }
            }
            for (ParameterExpressionImpl<?> parameter : sqlParameters) {
                parameter.setParameter(metamodel, parameters, sqlIndex, this.parameters.get(parameter));
            }
            if (paginationParamsOrder.isAfterMainSql()) {
                if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.SQL_START_MAX) {
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                } else if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.SQL_START_END) {
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = (long)this.startPosition + (long)this.maxResult;
                        sqlIndex.increment();
                    }
                } else if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.SQL_END_START) {
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = (long)this.startPosition + (long)this.maxResult;
                        sqlIndex.increment();
                    }
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                } else {
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                }
            }
            return parameters;
        }
        MutableInt sqlIndex = new MutableInt(0);
        Object[] parameters = new Object[paramCount];
        for (ParameterExpressionImpl<?> parameter : sqlParameters) {
            parameter.setParameter(metamodel, parameters, sqlIndex, this.parameters.get(parameter));
        }
        return parameters;
    }

    private List<X> buildResultSet(CacheImpl cache, List<CacheReference[]> cachedResults) {
        MetamodelImpl metamodel = this.em.getMetamodel();
        this.results = Lists.newArrayList();
        for (int i = 0; i < cachedResults.size(); ++i) {
            CacheReference[] references = cachedResults.get(i);
            if (references.length == 1) {
                EntityTypeImpl childType = metamodel.entity(references[0].getType());
                Object instance = this.em.find(childType.getJavaType(), references[0].getId());
                this.results.add(instance);
                continue;
            }
            Object[] instanceArray = new Object[references.length];
            for (int j = 0; j < references.length; ++j) {
                EntityTypeImpl childType = metamodel.entity(references[0].getType());
                instanceArray[j] = this.em.find(childType.getJavaType(), references[0].getId());
            }
            this.results.add(instanceArray);
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X> buildResultSet(Object[] parameters, CacheStoreMode cacheStoreMode) {
        this.results = Lists.newArrayList();
        ConnectionImpl connection = this.em.getConnection();
        try {
            new QueryRunner(this.em.getMetamodel().getJdbcAdaptor().isPmdBroken()).query((Connection)connection, this.sql, this, parameters);
            if ((cacheStoreMode == CacheStoreMode.REFRESH || cacheStoreMode == CacheStoreMode.USE) && this.q instanceof CriteriaQueryImpl) {
                this.emf.getCache().put(this.sql, parameters, this.results);
            }
            List<X> list = this.results;
            this.em.closeConnectionIfNecessary();
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.em.closeConnectionIfNecessary();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error(e, "Query failed" + LOG.lazyBoxed(this.sql, parameters));
                EntityTransactionImpl transaction = this.em.getTransaction();
                if (transaction != null) {
                    transaction.setRollbackOnly();
                }
                throw new PersistenceException("Query failed", (Throwable)e);
            }
        }
    }

    private void dumpResultSet() throws SQLException {
        int i;
        int[] lengths = new int[this.labels.length];
        for (int i2 = 0; i2 < lengths.length; ++i2) {
            lengths[i2] = this.max(lengths[i2], StringUtils.length((String)this.labels[i2]));
        }
        for (Map<String, Object> data : this.data) {
            for (i = 0; i < this.labels.length; ++i) {
                Object value = data.get(this.md.getColumnName(i + 1));
                if (value == null) continue;
                lengths[i] = this.max(lengths[i], StringUtils.length((String)value.toString()));
            }
        }
        int length = 1;
        for (int l : lengths) {
            length += l + 3;
        }
        StringBuffer dump = new StringBuffer("Query returned {0} row(s):\n");
        dump.append(StringUtils.repeat((String)"-", (int)length));
        dump.append("\n| ");
        for (i = 0; i < this.labels.length; ++i) {
            String strValue = StringUtils.abbreviate((String)this.labels[i], (int)lengths[i]);
            strValue = StringUtils.rightPad((String)strValue, (int)lengths[i]);
            dump.append(strValue);
            dump.append(" | ");
        }
        dump.append("\n");
        dump.append(StringUtils.repeat((String)"-", (int)length));
        for (Map<String, Object> data : this.data) {
            dump.append("\n| ");
            for (int i3 = 0; i3 < this.labels.length; ++i3) {
                Object value = data.get(this.md.getColumnName(i3 + 1));
                String strValue = value != null ? value.toString() : "!NULL!";
                strValue = StringUtils.abbreviate((String)strValue, (int)lengths[i3]);
                strValue = value instanceof Number ? StringUtils.leftPad((String)strValue, (int)lengths[i3]) : StringUtils.rightPad((String)strValue, (int)lengths[i3]);
                dump.append(strValue);
                dump.append(" | ");
            }
        }
        dump.append("\n");
        dump.append(StringUtils.repeat((String)"-", (int)length));
        LOG.debug(dump.toString(), this.data.size());
    }

    public int executeUpdate() {
        Object[] parameters = this.applyParameters();
        try {
            this.em.assertTransaction();
            return new QueryRunner(this.em.getJdbcAdaptor().isPmdBroken()).update((Connection)this.em.getConnection(), this.sql, parameters);
        }
        catch (SQLException e) {
            LOG.error(e, "Query failed" + LOG.lazyBoxed(this.sql, parameters));
            EntityTransactionImpl transaction = this.em.getTransaction();
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
            throw new PersistenceException("Query failed", (Throwable)e);
        }
    }

    public BaseQuery<X> getCriteriaQuery() {
        return this.q;
    }

    public int getFirstResult() {
        return this.startPosition;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Map<String, Object> getHints() {
        return Maps.newHashMap(this.hints);
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public int getMaxResults() {
        return this.maxResult;
    }

    public ParameterExpressionImpl<?> getParameter(int position) {
        for (Map.Entry<ParameterExpressionImpl<?>, Object> entry : this.parameters.entrySet()) {
            if (!Integer.valueOf(position).equals(entry.getKey().getPosition())) continue;
            return entry.getKey();
        }
        return this.getParameter(Integer.toString(position));
    }

    public <T> ParameterExpressionImpl<T> getParameter(int position, Class<T> type) {
        return this.getParameter(position);
    }

    public ParameterExpressionImpl<?> getParameter(String name) {
        for (Map.Entry<ParameterExpressionImpl<?>, Object> entry : this.parameters.entrySet()) {
            if (!name.equals(entry.getKey().getAlias())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Parameter with the name " + name + " does not exist");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.getParameter(name);
    }

    public Set<Parameter<?>> getParameters() {
        HashSet parameters = Sets.newHashSet();
        parameters.addAll(this.q.getParameters());
        return parameters;
    }

    public Object getParameterValue(int position) {
        return this.parameters.get(this.getParameter(position));
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.parameters.get(param);
    }

    public Object getParameterValue(String name) {
        return this.parameters.get(this.getParameter(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<X> getResultList() {
        ManagedInstance.LOCK_CONTEXT.set(this.getLockMode());
        try {
            List<X> list = this.getResultListImpl();
            return list;
        }
        finally {
            ManagedInstance.LOCK_CONTEXT.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X> getResultListImpl() {
        CacheStoreMode cacheStoreMode;
        if (this.results != null) {
            return this.results;
        }
        this.em.getSession().setLoadTracker();
        CacheImpl cache = this.emf.getCache();
        CacheRetrieveMode cacheRetrieveMode = (CacheRetrieveMode)this.hints.get("javax.persistence.cache.retrieveMode");
        if (cacheRetrieveMode != null) {
            cache.setCacheRetrieveMode(cacheRetrieveMode);
        }
        if ((cacheStoreMode = (CacheStoreMode)this.hints.get("javax.persistence.cache.storeMode")) != null) {
            cache.setCacheStoreMode(cacheStoreMode);
        }
        try {
            List<CacheReference[]> cachedResults;
            CriteriaQueryImpl cq;
            boolean hasLock;
            LockModeType lockMode = this.getLockMode();
            boolean bl = hasLock = lockMode == LockModeType.PESSIMISTIC_READ || lockMode == LockModeType.PESSIMISTIC_WRITE || lockMode == LockModeType.PESSIMISTIC_FORCE_INCREMENT;
            if (hasLock) {
                this.sql = this.em.getJdbcAdaptor().applyLock(this.sql, lockMode);
            }
            Object[] parameters = this.applyParameters();
            if (cacheRetrieveMode == CacheRetrieveMode.USE && !hasLock && this.q instanceof CriteriaQueryImpl && (cq = (CriteriaQueryImpl)this.q).getSelection().isEntityList() && (cachedResults = cache.get(this.sql, parameters)) != null) {
                List<X> list = this.buildResultSet(cache, cachedResults);
                return list;
            }
            List<X> list = this.buildResultSet(parameters, cacheStoreMode);
            return list;
        }
        finally {
            this.em.getSession().releaseLoadTracker();
            if (cacheRetrieveMode != null) {
                cache.setCacheRetrieveMode(null);
            }
            if (cacheStoreMode != null) {
                cache.setCacheStoreMode(null);
            }
        }
    }

    public X getSingleResult() {
        List<X> resultList = this.getResultList();
        if (resultList.size() > 1) {
            throw new NonUniqueResultException();
        }
        if (resultList.size() == 0) {
            throw new NoResultException();
        }
        return resultList.get(0);
    }

    public List<X> handle(ResultSet rs) throws SQLException {
        this.md = rs.getMetaData();
        CriteriaQueryImpl cq = (CriteriaQueryImpl)this.q;
        Selection selection = cq.getSelection();
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            this.prepareLabels(this.md);
        }
        SessionImpl session = this.em.getSession();
        while (rs.next()) {
            Object instance = selection.handle(this, session, rs);
            if (!cq.isDistinct() || !this.results.contains(instance)) {
                this.results.add(instance);
            }
            if (!debug) continue;
            this.storeData(rs);
        }
        LockModeType lockMode = this.getLockMode();
        if (lockMode != null) {
            for (X instance : this.results) {
                this.em.lock(session.get(instance), lockMode, null);
            }
        }
        if (debug) {
            this.dumpResultSet();
        }
        return this.results;
    }

    public boolean isBound(Parameter<?> param) {
        return this.parameters.containsKey(param);
    }

    private int max(int length1, int length2) {
        return Math.min(30, Math.max(length1, length2));
    }

    private void prepareLabels(ResultSetMetaData md) throws SQLException {
        this.labels = new String[md.getColumnCount()];
        for (int i = 0; i < this.labels.length; ++i) {
            String label = md.getColumnName(i + 1) + " (" + md.getColumnTypeName(i + 1) + ")";
            this.labels[i] = label = StringUtils.abbreviate((String)label, (int)30);
        }
    }

    private QueryImpl<X> putParam(Parameter<?> param, Object value) {
        this.parameters.put((ParameterExpressionImpl)param, value);
        return this;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    public QueryImpl<X> setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        return this;
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public TypedQuery<X> setMaxResults(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter((Parameter<Calendar>)this.getParameter(position, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(int position, java.util.Date value, TemporalType temporalType) {
        return this.setParameter((Parameter<java.util.Date>)this.getParameter(position, java.util.Date.class), value, temporalType);
    }

    public QueryImpl<X> setParameter(int position, Object value) {
        return this.putParam((Parameter<?>)this.getParameter(position), value);
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        switch (temporalType) {
            case DATE: {
                return this.putParam(param, new Date(value.getTimeInMillis()));
            }
            case TIME: {
                return this.putParam(param, new Time(value.getTimeInMillis()));
            }
        }
        return this.putParam(param, new Timestamp(value.getTimeInMillis()));
    }

    public TypedQuery<X> setParameter(Parameter<java.util.Date> param, java.util.Date value, TemporalType temporalType) {
        switch (temporalType) {
            case DATE: {
                return this.putParam(param, new Date(value.getTime()));
            }
            case TIME: {
                return this.putParam(param, new Time(value.getTime()));
            }
        }
        return this.putParam(param, new Timestamp(value.getTime()));
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        this.parameters.put((ParameterExpressionImpl)param, value);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(String name, java.util.Date value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, java.util.Date.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        return this.putParam((Parameter<?>)this.getParameter(name), value);
    }

    public void storeData(ResultSet rs) throws SQLException {
        HashMap data = Maps.newHashMap();
        int columnCount = this.md.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Object value = rs.getObject(i + 1);
            data.put(this.md.getColumnName(i + 1), value);
        }
        this.data.add(data);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this;
    }
}

