/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConstantExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class FunctionExpression<T>
extends AbstractExpression<T> {
    private final List<Expression<?>> arguments = Lists.newArrayList();
    private String alias;
    private final String function;

    public FunctionExpression(Class<T> javaType, String function, Expression<?> ... arguments) {
        super(javaType);
        this.function = function;
        for (Expression<?> argument : arguments) {
            this.arguments.add(argument);
        }
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        return this.function + "(" + Joiner.on((String)", ").join((Iterable)Lists.transform(this.arguments, (Function)new Function<Expression<?>, String>(){

            public String apply(Expression<?> input) {
                return ((AbstractExpression)input).generateJpqlRestriction(query);
            }
        })) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(final BaseQueryImpl<?> query) {
        return new String[]{this.function + Joiner.on((String)"").join((Iterable)Lists.transform(this.arguments, (Function)new Function<Expression<?>, String>(){

            public String apply(Expression<?> input) {
                if (input instanceof ConstantExpression) {
                    String result = ((AbstractExpression)input).getSqlRestrictionFragments(query)[0];
                    if (result.startsWith("'")) {
                        return result.substring(1, result.length() - 1);
                    }
                    return result;
                }
                return ((AbstractExpression)input).getSqlRestrictionFragments(query)[0];
            }
        }))};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (T)row.getObject(this.alias);
    }
}

