/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.join.ListJoinImpl;
import org.batoo.jpa.core.impl.jdbc.JoinTable;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class IndexExpression
extends AbstractExpression<Integer> {
    private final ListJoinImpl<?, ?> listJoin;
    private final OrderColumn orderColumn;
    private String alias;

    public IndexExpression(ListJoinImpl<?, ?> listJoin, OrderColumn orderColumn) {
        super(Integer.class);
        this.listJoin = listJoin;
        this.orderColumn = orderColumn;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "index(" + this.listJoin.getAlias() + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String tableAlias = this.listJoin.getTableAlias(query, this.orderColumn.getTable());
        if (this.orderColumn.getTable() instanceof JoinTable) {
            tableAlias = tableAlias + "_J";
        }
        return new String[]{tableAlias + "." + this.orderColumn.getName()};
    }

    @Override
    public Integer handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return ((Number)row.getObject(this.alias)).intValue();
    }
}

