/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.BooleanExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class PredicateImpl
extends BooleanExpression
implements Predicate {
    private final Predicate.BooleanOperator operator;
    private final boolean negated;
    private final List<BooleanExpression> expressions = Lists.newArrayList();
    private String alias;

    public PredicateImpl(AbstractExpression<Boolean> expression) {
        this(false, Predicate.BooleanOperator.AND, expression);
    }

    public PredicateImpl(AbstractExpression<Boolean> ... expressions) {
        this(false, Predicate.BooleanOperator.AND, expressions);
    }

    public PredicateImpl(boolean negated, Predicate.BooleanOperator operator, Expression<Boolean> ... expressions) {
        super((Expression<Boolean>)null);
        this.negated = negated;
        this.operator = operator;
        for (Expression<Boolean> expression : expressions) {
            if (expression instanceof BooleanExpression) {
                this.expressions.add((BooleanExpression)expression);
                continue;
            }
            this.expressions.add(new BooleanExpression(expression));
        }
    }

    public PredicateImpl(boolean negated, Predicate.BooleanOperator operator, Predicate ... predicates) {
        super((Expression<Boolean>)null);
        this.negated = negated;
        this.operator = operator;
        for (Predicate predicate : predicates) {
            this.expressions.add((PredicateImpl)predicate);
        }
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        String predicates = Joiner.on((String)(" " + this.operator.name() + " ")).join((Iterable)Lists.transform(this.expressions, (Function)new Function<AbstractExpression<Boolean>, String>(){

            public String apply(AbstractExpression<Boolean> input) {
                return input.generateJpqlRestriction(query);
            }
        }));
        if (StringUtils.isBlank((String)predicates)) {
            predicates = "true";
        }
        if (this.negated) {
            return "not (" + predicates + ")";
        }
        return predicates;
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.alias;
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlRestriction(final BaseQueryImpl<?> query) {
        String predicates = Joiner.on((String)(" " + this.operator.name() + " ")).join((Iterable)Lists.transform(this.expressions, (Function)new Function<BooleanExpression, String>(){

            public String apply(BooleanExpression input) {
                return input.generateSqlRestriction(query);
            }
        }));
        if (StringUtils.isBlank((String)predicates)) {
            predicates = "TRUE";
        }
        if (this.negated) {
            return "NOT (" + predicates + ")";
        }
        return predicates;
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.generateSqlRestriction(query) + " AS " + this.alias;
        }
        return this.generateSqlRestriction(query);
    }

    public List<Expression<Boolean>> getExpressions() {
        ArrayList expressions = Lists.newArrayList();
        expressions.addAll(this.expressions);
        return expressions;
    }

    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return row.getBoolean(this.alias);
    }

    public boolean isNegated() {
        return this.negated;
    }

    public PredicateImpl not() {
        return new PredicateImpl(true, this.operator, this.expressions.toArray(new Expression[this.expressions.size()]));
    }
}

