/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConstantExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.util.Pair;

public class SimpleCaseImpl<C, R>
extends AbstractExpression<R>
implements CriteriaBuilder.SimpleCase<C, R> {
    private final Expression<? extends C> inner;
    private final List<Pair<Expression<C>, Expression<? extends R>>> conditions = Lists.newArrayList();
    private Expression<? extends R> otherwise;
    private String alias;

    public SimpleCaseImpl(Expression<? extends C> inner) {
        super(Object.class);
        this.inner = inner;
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        String whens = Joiner.on((String)"\n\t").join((Iterable)Lists.transform(this.conditions, (Function)new Function<Pair<Expression<C>, Expression<? extends R>>, String>(){

            public String apply(Pair<Expression<C>, Expression<? extends R>> input) {
                AbstractExpression when = (AbstractExpression)input.getFirst();
                AbstractExpression then = (AbstractExpression)input.getSecond();
                return "when " + when.generateJpqlRestriction(query) + " then " + then.generateJpqlRestriction(query);
            }
        }));
        String otherwise = "\n\telse " + ((AbstractExpression)this.otherwise).generateJpqlRestriction(query);
        return "case " + ((AbstractExpression)this.inner).generateJpqlRestriction(query) + "\n\t" + whens + otherwise + "\nend";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    public Expression<C> getExpression() {
        return this.inner;
    }

    @Override
    public String[] getSqlRestrictionFragments(final BaseQueryImpl<?> query) {
        final String innerFragment = ((AbstractExpression)this.inner).getSqlRestrictionFragments(query)[0];
        String whens = Joiner.on((String)"\n\t").join((Iterable)Lists.transform(this.conditions, (Function)new Function<Pair<Expression<C>, Expression<? extends R>>, String>(){

            public String apply(Pair<Expression<C>, Expression<? extends R>> input) {
                String conditionFragment = ((AbstractExpression)input.getFirst()).getSqlRestrictionFragments(query)[0];
                String resultFragment = ((AbstractExpression)input.getSecond()).getSqlRestrictionFragments(query)[0];
                return "WHEN " + innerFragment + " = " + conditionFragment + " THEN " + resultFragment;
            }
        }));
        String otherwise = "\n\tELSE " + ((AbstractExpression)this.otherwise).getSqlRestrictionFragments(query)[0];
        return new String[]{"CASE\n\t" + whens + otherwise + "\nEND"};
    }

    @Override
    public R handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (R)row.getObject(this.alias);
    }

    public Expression<R> otherwise(Expression<? extends R> result) {
        this.otherwise = result;
        return this;
    }

    public Expression<R> otherwise(R result) {
        this.otherwise((R)new ConstantExpression<R>(null, result));
        return this;
    }

    public SimpleCaseImpl<C, R> when(AbstractExpression<C> condition, AbstractExpression<R> result) {
        this.conditions.add(new Pair<AbstractExpression<C>, AbstractExpression<R>>(condition, result));
        return this;
    }

    public CriteriaBuilder.SimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        this.conditions.add(new Pair<ConstantExpression<C>, Expression<? extends R>>(new ConstantExpression<C>(null, condition), result));
        return this;
    }

    public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
        return this.when(condition, (R)new ConstantExpression<R>(null, result));
    }
}

