/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.annotations.Beta;
import java.sql.SQLException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.DataSourceImpl;

@Beta
public class ConnectionFactory
extends BasePoolableObjectFactory<ConnectionImpl> {
    private static final BLogger LOG = BLoggerFactory.getLogger(ConnectionFactory.class);
    private final DataSourceImpl dataSource;

    public ConnectionFactory(DataSourceImpl dataSource) {
        this.dataSource = dataSource;
    }

    public void activateObject(ConnectionImpl obj) throws Exception {
        obj.reset();
    }

    public void destroyObject(ConnectionImpl obj) throws Exception {
        obj.close0();
    }

    public ConnectionImpl makeObject() throws SQLException {
        return this.dataSource.getConnection0();
    }

    public void passivateObject(ConnectionImpl obj) throws Exception {
        try {
            obj.setAutoCommit(true);
        }
        catch (Exception e) {
            LOG.error(e, "Error while returning connection");
        }
    }

    public boolean validateObject(ConnectionImpl obj) {
        try {
            return obj.isValid(1000);
        }
        catch (SQLException e) {
            return false;
        }
    }
}

